<?php

namespace Tests;

use App\System\Site\Database\Models\Reseller;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Illuminate\Foundation\Testing\TestCase as BaseTestCase;
use Faker\Factory as Faker;
use Illuminate\Support\Facades\DB; //to create the fake data for test

abstract class TestCase extends BaseTestCase
{
    use CreatesApplication,DatabaseMigrations,DatabaseTransactions;

    protected $faker;

    /**
     * setup each Test
     */
    public function setUp()
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        $this->faker=Faker::create();
        $data=factory(Reseller::class)->raw(['domain'=>'www']);
        DB::table('sites')->insert($data);

        //creating mock user for activity log
        $data=factory(\App\System\User\Database\Models\User::class)->raw();
        DB::table('users')->insert($data);
        $user=\App\System\User\Database\Models\User::first();
        $this->be($user);

    }

    /**
     *rest the DB
     *we are using testDB for testing than the working db
     */
    public function tearDown()
    {
        $this->artisan('migrate:reset');
        \Mockery::close();
        parent::tearDown(); // TODO: Change the autogenerated stub

    }
    /**
     *Make the validator
     *
     * @param $field
     * @param $value
     * @return mixed
     */
    protected function getFieldValidator($request,$field, $value)
    {
        $rules = $request->rules();
        return $this->app['validator']->make([$field => $value], [$field => $rules[$field]]);
    }

    /**
     *
     * make a validator for testing validation if it passes or not
     *
     * @param $request
     * @param $field
     * @param $value
     * @return mixed
     */
    protected function validateField($request,$field, $value)
    {
        return $this->getFieldValidator($request,$field, $value)->passes();
    }

}
