<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 1/14/19
 * Time: 2:21 PM
 */

namespace Tests\Feature;


use App\System\Site\Database\Models\Reseller;
use App\System\UAC\Database\Models\Permission;
use App\System\UAC\Database\Models\PermissionGroup;
use App\System\User\Database\Models\ActiveUser;
use App\System\User\Database\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Tests\TestCase;

class FeatureTestCase extends TestCase
{

    /**
     * @var
     */
    public $permissionGroup;

    /**
     * @var
     */
    protected $reseller;


    /**
     * @var
     */
    protected $defaultReseller;

    /**
     * @var
     */
    protected $user;

    /**
     * @var
     */
    protected $authToken;

    public function setUp()
    {
        parent::setUp();

        $this->defaultReseller = DB::table('sites')->where('domain', 'www')->first();

        \DB::table('oauth_clients')->insert([
            'user_id' => env('AUTH_CLIENT_ID', 1),
            'name' => 'test',
            'secret' => env('AUTH_CLIENT_SECRET', 'sAM74wDFo3QNF5t9W04OLI31cGaOv4l6N8mRXdqG'),
            'redirect' => 'http://localhost/auth/callback',
            'password_client' => '1',
            'personal_access_client' => '0',
            'revoked' => '0',
            'created_at' => new \DateTime,
            'updated_at' => new \DateTime,
        ]);

        \Artisan::call('db:seed', [
            '--class' => \PermissionSeeder::class
        ]);

        $this->reseller = factory(Reseller::class)->create(['status' => 2]);
        $this->user = factory(User::class)->create(['status' => 2, 'is_locked' => 0]);

        $data = [
            'username' => $this->user->email,
            'password' => 'password'
        ];

        //login
        $result = $this->post('/api/auth/authenticate', $data);
        $this->authToken = ['authorization' => 'Bearer ' . $result->headers->get('Access-Token')];
    }


    public function tearDown()
    {
        parent::tearDown();
        Model::clearBootedModels();
    }
}