<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Redirect;

Route::group(['middleware'=>'secureConnection'],function () {

    include(__DIR__."/angular-routes.php");
    Route::post('password/reset','\App\Http\Controllers\Auth\ForgotPasswordController@sendResetLinkEmail');
    Route::get('register/confirmation', '\App\Http\Controllers\Auth\RegisterController@confirmEmail')->name('email.confirmationLink');

    Route::get('/themes/{templateName}/assets/{folder}/{fileName}','FileController@file');
});
