<?php
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix'=>'auth'],function(){
    Route::post('authenticate','\App\Http\Controllers\Auth\ApiLoginController@authenticate');
    Route::post('register','\App\Http\Controllers\Auth\RegisterController@create');
    Route::post('refresh-token','\App\Http\Controllers\Auth\ApiLoginController@refreshToken');
    Route::post('upload-resources-register','\App\Http\Controllers\Auth\RegisterController@uploadResources');

    Route::group(['middleware'=>'auth:api'],function(){
        Route::get('logout','\App\Http\Controllers\Auth\AuthController@logout');
        Route::get('me','\App\Http\Controllers\Auth\AuthController@getAuthUser');
        Route::put('me','\App\Http\Controllers\Auth\AuthController@update');
        Route::post('me/avatar','\App\Http\Controllers\Auth\AuthController@updateAvatar');
        Route::get('/me/permissions','\App\Http\Controllers\Auth\AuthController@permissions');
        Route::put('me/password','\App\Http\Controllers\Auth\AuthController@updatePassword');

    });
});
Route::post('upload-resources','\App\Http\Controllers\Controller@uploadResources')->middleware('auth:api');

Route::post('password/reset','\App\Http\Controllers\Auth\ForgotPasswordController@sendResetLinkEmail');
Route::post('password/reset/{token}','\App\Http\Controllers\Auth\ResetPasswordController@reset')->name('password.reset');
Route::post('resource/existence','\App\Http\Controllers\Controller@checkResourceExistence');
