<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 10/31/2017
 * Time: 8:41 PM
 */

use Illuminate\Support\Facades\Route;

$routes = [
    'root'=>'/',

    'root.authenticate'=> 'authenticate',
    'frontend.home'=>'home',
    'frontend.login'=>'auth/login',
    'frontend.register'=>'auth/register',
    'frontend.forgotPassword'=>'auth/forgot-password',
    'password.request'=>'auth/password/reset/{token}',
    'password.update'=>"auth/password/update",
    'manage.home' => 'manage',

    'manage.publishers' => "manage/publishers",
    'manage.publishers.id' => "manage/publishers/{id}",
    'manage.publishers.show' => "manage/publishers/{id}/show",
    'manage.publishers.prefixes' => "manage/publishers/{id}/prefixes",

    'manage.me' => 'manage/me',
    'manage.me.profile' => 'manage/me/profile',

    'manage.isbn-applications' => 'manage/isbn-applications',
    'manage.isbn-applications.create' => 'manage/isbn-applications/create',
    'manage.isbn-applications.id' => 'manage/isbn-applications/{id}',
    'manage.isbn-applications.show' => 'manage/isbn-applications/{id}/show',
    'manage.isbn-applications.edit' => 'manage/isbn-applications/{id}/edit',

    'manage.issued-isbns' => 'manage/issued-isbns',
    'manage.users' => 'manage/users',

    'public.publishers' => 'publishers',
    'public.isbns' => 'published-isbns',
    'public.isbns.show' => 'published-isbns/{id}/show',
    'public.1_isbns' => 'isbns',
    'public.2_isbns' => 'books',
    'public.3_isbns' => 'published-books',




];

foreach ($routes as $name=>$route){
    Route::get($route,'AngularAppController@index')->name($name);
}
