@extends('emails.base_email')

@section('mail_body')
    <p>We have received an ISBN request mail from you. We are processing it. You will be notified when an ISBN is issued. Following are the details we received.</p>
    <p>
        <strong>ISBN Application ID: </strong> {{$application->id}}<br>
        <strong>Requested Date: </strong> {{$application->requested_date}}<br>
        <strong>Title: </strong> <a href="{{url('/manage/isbn-applications/'.$application->id. '/show')}}">{{$application->title}}</a><br>
        <strong>Subject: </strong> {{$application->subject}}<br>
        <strong>Authors: </strong>
        @foreach($application->authors as $index=>$author)
            {{$author->name}}
            @if($index < $application->authors->count()-1)
                ,
            @endif
        @endforeach
        <br>
        <strong>Accession number: </strong> {{$application->accession_number}}<br>
        <strong>Edition: </strong> {{$application->edition}}<br>
        <strong>Language: </strong> {{$application->language}}<br>
        <strong>Corporate author: </strong> {{$application->corporate_author}}<br>
        <strong>Corporate author address: </strong> {{$application->corporate_author_address}}<br>
        <strong>Affiliation author address: </strong> {{$application->affiliation_author_address}}<br>
        <strong>Year: </strong> {{$application->year}}<br>
        <strong>call number: </strong> {{$application->call_number}}<br>

        <strong>Publisher: </strong> {{$application->publisher->title}}<br>
        <strong>Publisher address: </strong> {{$application->publisher->street}}<br>
        <strong>Publisher phone number: </strong> {{$application->publisher->phone_number}}<br>
        <strong>Publisher e-mail: </strong> {{$application->publisher->email}}<br>

    </p>
@stop
