import {BaseResourceInterface} from "../../../../../system/datamodels/BaseResourceInterface";
import {IsbnTypeEnum} from "../enums/isbn.type.enum";
import {IsbnBoundTypeEnum} from "../enums/isbn-bound-type.enum";
import {IsbnIllustrationTypeEnum} from "../enums/isbn-illustration-type.enum";
import {IsbnIllustrationColorEnum} from "../enums/isbn-illustration-color.enum";
import {BasePublisherInterface} from "../../publisher/interfaces/BasePublisherInterface";

export interface BaseIsbnApplicationInterface extends BaseResourceInterface {
  requested_date?: string;
  isbn_type?: IsbnTypeEnum;
  title?: string;
  edition?: string;
  subject?: string;
  author_name?: string;
  accession_number?: string;
  received_status?: number;
  language?: string;
  type?: IsbnBoundTypeEnum;
  corporate_author?: string;
  corporate_author_address?: string;
  year?: number;
  preliminary_page?: string;
  textual_page?: string;
  number_of_pages?: number;
  price?: number;
  call_number?: string;
  book_number?: string;
  keywords?: string;
  illustration_type?: IsbnIllustrationTypeEnum;
  photo_illustration?: IsbnIllustrationColorEnum;
  illustration_color?: IsbnIllustrationColorEnum;
  book_cover_url?: string;
  last_isbn_number?: string;
  deposit_slip_url?: string;
  readonly?: boolean;
  publisher?: BasePublisherInterface;

}
