import { NgModule } from "@angular/core";
import { RouterModule } from "@angular/router";
import { UsersComponent } from "./users.component";
import { UsersListComponent } from "./components/users-list/users-list.component";
import { UserViewComponent } from "./components/user-view/user-view.component";

@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: UsersComponent,
        children: [
          {
            path: '',
            component: UsersListComponent
          },
          {
            path: ':id/show',
            component: UserViewComponent
          },
        ]
      },
    ])
  ],
  exports: [RouterModule]
})

export class UsersRoutingModule { }
