import {Component, Injector, OnDestroy, OnInit} from '@angular/core';
import {BaseComponent} from '../../../../../system/controllers/BaseComponent';
import {UserService} from '../../services/user.service';
import {NewUserComponent} from '../../../../../shared/new-user-component/new-user.component';
import {StatusLabelConfig} from '../../../../../system/components/nico-status/nico-status.component';
import {StatusEnum} from '../../../../../system/enums/status.enum';
import {Collection} from '../../../../../system/utilities/Collection';

@Component({
  selector: 'app-users-list',
  templateUrl: './users-list.component.html',
  styleUrls: ['./users-list.component.scss']
})
export class UsersListComponent extends BaseComponent implements OnInit, OnDestroy {

  protected currentService: UserService;


  protected statusLabelConfig: Collection<StatusLabelConfig>;

  /**
   * Constructor
   * @param injector
   * @param service
   */
  constructor(injector: Injector, protected service: UserService) {
    super(injector);
  }

  /**
   * On init hook
   */
  public ngOnInit() {
    super.ngOnInit();
    this.setPageTitle('mod_manage.mod_users.page_title');
    this.getList();
    this.statusLabelConfig = new Collection([
      {status: StatusEnum.Unpublished, value: 'mod_commons.inactive_label'},
      {status: StatusEnum.Published, value: 'mod_commons.active_label'}
    ]);
  }

  /**
   * Add new item
   */
  public newItem() {
    this.currentService = this.service;
    this.nicoCtrl.create(NewUserComponent, {
      htmlTemplateAsIs: true,
      data: {service: this.currentService},
      modalClass: 'custom-modal custom-modal-540',
      onOkayProcessComplete: () => {
        this.getList();
      },
      onDestroy: () => {
        this.setPageTitle('mod_manage.mod_users.page_title');
      },
    }).present();
  }
}
