import {Component, Injector, OnDestroy, OnInit} from '@angular/core';
import {BaseComponent} from '../../../../../system/controllers/BaseComponent';
import {BaseUserInterface} from '../../../../../shared/base/contituents/user/interfaces/UserBaseInterface';
import {BaseUser} from '../../../../../shared/base/contituents/user/models/BaseUser';
import {UserService} from '../../services/user.service';
import {ServerResponse} from '../../../../../system/responses/ServerResponse';
import {PermissionGroupPermissionOptions} from '../../../../../shared/enums/permission-options';
import {OperatorOptions} from '../../../../../shared/enums/operator-options';
import {PermissionGroupListService} from '../../../../../shared/groups-permissions/permission-group-list/permission-group-list.service';
import {Collection} from '../../../../../system/utilities/Collection';
import {StatusEnum} from '../../../../../system/enums/status.enum';
import {StatusLabelConfig} from '../../../../../system/components/nico-status/nico-status.component';

@Component({
  selector: 'app-user-view',
  templateUrl: './user-view.component.html',
  styleUrls: ['./user-view.component.scss']
})
export class UserViewComponent extends BaseComponent implements OnInit, OnDestroy {
    /**
     * Model associated directly with this component
     */
    public model: BaseUserInterface = new BaseUser();

    // public isSuperAdmin: boolean = false;

    public permissionGroupPermissionOptions: PermissionGroupPermissionOptions = new PermissionGroupPermissionOptions();

    /**
     * operator AND / OR
     */
    public operatorOption: OperatorOptions = new OperatorOptions();

    public statusLabelConfig: Collection<StatusLabelConfig> = new Collection([
        {status: StatusEnum.Unpublished, value: 'mod_commons.inactive_label'},
        {status: StatusEnum.Published, value: 'mod_commons.active_label'}
    ]);

    /**
     * Constructor
     * @param injector
     * @param service
     * @param permGroupService
     */
    public constructor(injector: Injector, protected service: UserService, protected permGroupService: PermissionGroupListService) {
        super(injector);
    }

    protected initList() {
        this.getUser();
    }

    ngOnInit() {
        super.ngOnInit();
    }

    /**
     * On route param initialized hook
     */
    public onRouteParamInitialized() {
        super.onRouteParamInitialized();
        this.initList();
    }

    /**
     * get current user
     */
    public getUser() {
        const spinner = this.ajaxSpinner.showSpinner();
        this.service.find(this.routeParams.get('id')).subscribe((item: BaseUser) => {
            spinner.hide();
            this.model = item;
            // this.checkForSuperAdmin();
            this.setPageTitle('mod_manage.mod_users.view.page_title', item.getFullName());
        }, (err: ServerResponse) => {
            spinner.hide();
            this.showErrorToast(err.status.message);
            throw err;
        });
    }
}

