import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';

import { SharedModule } from '../../../shared/shared.module';
import { PublishersRoutingModule } from './publishers-routing.module';
import { PublishersComponent } from './publishers.component';
import { PublisherService } from './services/publisher.service';
import {PublishersListComponent} from "./components/publisher-list/publishers-list.component";
import {AddPublisherComponent} from "./components/add-publisher/add-publisher.component";
import {PublisherViewComponent} from "./components/publisher-view/publisher-view.component";
import {PublisherShowComponent} from "./components/publisher-view/pages/show/publisher.show.component";
import {PrefixesComponent} from "./components/publisher-view/pages/prefixes/prefixes.component";
import {PublisherPrefixService} from "./services/publisher-prefix.service";
import {AddPrefixComponent} from "./components/publisher-view/pages/prefixes/components/add-prefix.component";

@NgModule({
  imports: [CommonModule, PublishersRoutingModule, SharedModule.forRoot()],
  declarations: [PublishersComponent, PublishersListComponent, AddPublisherComponent,
    PublisherShowComponent,
    PrefixesComponent,
    AddPrefixComponent,
    PublisherViewComponent],
  exports: [],
  entryComponents: [AddPublisherComponent, AddPrefixComponent],
  providers: [PublisherService, PublisherPrefixService]
})
export class PublishersModule { }
