import {NgModule} from '@angular/core';
import {RouterModule} from '@angular/router';
import {PublishersComponent} from './publishers.component';
import {PublishersListComponent} from "./components/publisher-list/publishers-list.component";
import {PublisherViewComponent} from "./components/publisher-view/publisher-view.component";
import {PublisherShowComponent} from "./components/publisher-view/pages/show/publisher.show.component";
import {PrefixesComponent} from "./components/publisher-view/pages/prefixes/prefixes.component";

@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: PublishersComponent,
        children: [
          {
            path: '',
            component: PublishersListComponent,
          },
          {
            path: ':id',
            component: PublisherViewComponent,
            data: {animation: 'default'},
            children: [
              {
                path: 'show',
                component: PublisherShowComponent
              },
              {
                path: 'prefixes',
                component: PrefixesComponent
              }
            ]
          },
        ]
      },
    ])
  ],
  exports: [RouterModule]
})
export class PublishersRoutingModule {
}
