import {BaseComponent} from "../../../../../../../system/controllers/BaseComponent";
import {Component, Injector, OnInit} from "@angular/core";
import {Publisher} from "../../../../models/Publisher";
import {PublisherService} from "../../../../services/publisher.service";

@Component({
  selector: 'app-publisher-show',
  templateUrl:  './publisher.show.component.html'
})
export class PublisherShowComponent extends BaseComponent implements OnInit {
  /**
   * Model
   */
  public model: Publisher;

  /**
   * service
   */
  public service: PublisherService;

  constructor(private injector: Injector) {
    super(injector);
    this.service = injector.get(PublisherService);
  }

  ngOnInit() {
    super.ngOnInit();
  }

  /**
   * On route param initialized hook
   */
  onRouteParamInitialized() {
    this.getResource();
  }

  /**
   * Get the resource
   */
  public getResource() {
    const subscription = this.activatedRoute.parent.params.subscribe((params: any) => {
      const spinner = this.ajaxSpinner.showSpinner();
      const fetchSubscription = this.service.find(params.id, {params: this.urlParams}).subscribe((item: Publisher) => {
        this.setPageTitle('mod_manage.mod_publishers.edit_page_title', item.title);
        this.model = item;
        spinner.hide();
        fetchSubscription.unsubscribe();
        subscription.unsubscribe();
      }, () => {
        spinner.hide();
      });
    });

  }

  public onUserSelect ($event) {
    this.appService.showConfirmDialog({
      message: "Are you sure you want to change the owner of this publisher?",
      onConfirm: () => {
        const spinner = this.ajaxSpinner.showSpinner('owner-selection-section');
        if ($event) {
          this.service.assignAdministrator(this.model, $event)
            .subscribe(() => {
              spinner.hide();
            }, () => {
              spinner.hide();
            });
        } else {
          this.service.removeAdministrator (this.model)
            .subscribe (() => {
              spinner.hide();
            }, () => {
              spinner.hide();
            });
        }
      }
    });
  }


}
