import {BaseComponent} from "../../../../../../../system/controllers/BaseComponent";
import {Component, Injector, OnInit} from "@angular/core";
import {PublisherPrefixService} from "../../../../services/publisher-prefix.service";
import {UrlParamsInterface} from "../../../../../../../shared/enums/UrlParamsInterface";
import {BasePublisherPrefixInterface} from "../../../../../../../shared/base/contituents/publisher/interfaces/BasePublisherPrefixInterface";
import {AddPrefixComponent} from "./components/add-prefix.component";
import {environment} from "../../../../../../../../environments/environment";

@Component({
  selector: 'app-publisher-prefix',
  templateUrl: 'prefixes.component.html'
})
export class PrefixesComponent extends BaseComponent implements OnInit {

  public isbnPrefix: string;
  public urlParams: UrlParamsInterface = {page: 1, sort_by: 'prefix', sort_order: 'desc'};

  constructor(injector: Injector) {
    super(injector);
    this.service = injector.get(PublisherPrefixService);
    this.isbnPrefix = environment.country_isbn_identifier;
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.setPageTitle("Prefixes");
    const subscription = this.activatedRoute.parent.params.subscribe((params: any) => {
      (<PublisherPrefixService> this.service).generateResourceUrl({publisherId: params.id});
      this.getList();
      if (subscription) {
        subscription.unsubscribe();
      }
    });
  }

  /**
   * Edit item
   * @param item
   */
  public openCreateModel(item?: BasePublisherPrefixInterface) {
    this.nicoCtrl.create(AddPrefixComponent, {
      htmlTemplateAsIs: true,
      data: {model: item},

      modalClass: 'custom-modal custom-modal-md',
      onOkayProcessComplete: () => {
        this.getList();
      }
    }).present();
  }

}
