import { Component, Injector, OnDestroy, OnInit, } from '@angular/core';

import { AbstractPublisherCreateComponent } from "../AbstractPublisherCreateComponent";
import { NicoModalController } from 'src/app/system/components/modal/NicoModalController';
@Component({
  selector: 'app-create-publisher',
  templateUrl: './add-publisher.component.html',
  styleUrls: []
})
export class AddPublisherComponent extends AbstractPublisherCreateComponent implements OnInit, OnDestroy {

  /**
   * The id for video add form
   * @var string
   */
  public formId: string = "add-publisher-form";



  /**
   * Constructor
   * @param injector
   * @param modalController
   */
  constructor(injector: Injector, protected modalController: NicoModalController) {
    super(injector);
  }

  /**
   *  Oninit lifecycle hook
   */
  public ngOnInit() {
    super.ngOnInit();
    this.setPageTitle('mod_manage.mod_publishers.add_page_title');
    this.modalTitle = 'mod_manage.mod_publishers.add_page_title';
    if (this.data.model) {
      this.setPageTitle("mod_manage.mod_publishers.edit_page_title", this.data.model.title);
      this.modalTitle = "Edit: " + this.data.model.title;
    }
  }
  /**
   * On form submit
   */
  public save(): any {
    this.saveForm().subscribe(() => {
      this.showSuccessToast('mod_manage.mod_publishers.add_success_message');
      this.okayCompleteListener();
      this.dismisser();
    });
  }

  /**
   * On cancle
   */

  public cancel() {
    this.formGroup.reset();
    this.cancelForm();
  }
}
