
import { Component, Injector, OnDestroy, OnInit } from '@angular/core';
import {BaseComponent} from "../../../system/controllers/BaseComponent";
import {RouterOutlet} from "@angular/router";
import {slideInAnimation} from "../../../system/animations";
import {IsbnApplicationService} from "../../../shared/services/isbn-application.service";


@Component({
    //moduleId: module.id,
    selector: 'app-isbn-applications',
    templateUrl: './isbn-application.component.html',
    styleUrls: [],
    animations: [slideInAnimation]

})
export class IsbnApplicationComponent extends BaseComponent implements OnInit, OnDestroy {


    constructor(injector: Injector, public service: IsbnApplicationService) {
        super(injector);

    }

    /**
     * Get the names OnInit
     */
    ngOnInit() {
        this.setPageTitle('ISBN Applications');
    }

    /**
     *  the Method that is called after route param is initialized
     *  If you need to grab something from route and then initialize component. Define them here.
     *  Note, this method will be called every-time if url is changed. So use it wisely.
     */
    public onRouteParamInitialized() {

    }

    prepareRoute(outlet: RouterOutlet) {
        return outlet && outlet.activatedRouteData;
    }

}

