import {BaseResourceInterface} from "../../../../../system/datamodels/BaseResourceInterface";
import {BasePermissionGroup} from "../../uac/models/BasePermissionGroup";
import {Collection} from "../../../../../system/utilities/Collection";
import {BasePermissionGroupInterface} from "../../uac/interfaces/BasePermissionGroupInterface";

export interface BaseUserInterface extends BaseResourceInterface {
  id: number;
  first_name?: string;
  last_name?: string;
  middle_name?: string;
  email?: string;
  image_url?: string;
  thumb_url?: string;
  [key: string]: any;
  company_docs_url?: string
  permissionGroups?: Collection<BasePermissionGroupInterface>;

  getFullName();

  can (permission: string): boolean;

}
