import { EventEmitter, Injectable } from '@angular/core';
import { BaseService } from "../../../../system/services/BaseService";
import { NicoHttp } from "../../../../system/requests/NicoHttp";
import {Publisher} from "../models/Publisher";
import {environment} from "../../../../../environments/environment";
import {BasePublisherInterface} from "../../../../shared/base/contituents/publisher/interfaces/BasePublisherInterface";
import {BaseUserInterface} from "../../../../shared/base/contituents/user/interfaces/UserBaseInterface";
import {Observable} from "rxjs";
@Injectable()
export class PublisherService extends BaseService {

    /**
     * The resource
     * @type {string}
     */
    protected resourceName: string = 'publishers';
    /**
     * Base resource url
     * @type {string}
     */
    protected resourceBaseUrl: string = '';
    /**
     *
     * @type {User}
     */
    protected resource: Publisher;

    /**
     * Constructor
     * @param http
     */
    public constructor(protected http: NicoHttp) {
        super(http, environment);
        this.resource = new Publisher();
        this.setResourceName(this.resourceName);
    }

    public assignAdministrator (publisher: BasePublisherInterface, user: BaseUserInterface): Observable<any> {
      return this.http.put(this.resourceBaseUrl + '/' + publisher.id + '/administrator/' + user.id, null);
    }

    public removeAdministrator (publisher: BasePublisherInterface): Observable<any> {
      return this.http.delete(this.resourceBaseUrl + '/' + publisher.id + '/administrator');
    }

    public requestPublisherOwnership (data: any): Observable<any> {
      return this.http.post(this.resourceBaseUrl + '/request-publisher-owner/create-wonership', data);
    }

}
