import {
  Component,
  Injector,
  OnInit,
} from '@angular/core';
import { FormGroup, Validators } from '@angular/forms';

import { AuthService } from '../../../../../shared/auth/services/auth.service';
import { RequestAddPublisherService } from '../../services/request-add-publisher.service';
import {BaseComponent} from "../../../../../system/controllers/BaseComponent";
import {Spinner} from "../../../../../system/services/AjaxSpinner";
import {ServerResponse} from "../../../../../system/responses/ServerResponse";
import {UploadFileOptionsInterface} from "../../../../../shared/upload-file-component/upload-file.options.interface";
import {PermissionGroupPermissionOptions} from '../../../../../shared/enums/permission-options';

@Component({
  selector: 'app-request-add-publisher',
  templateUrl: './request-add-publisher.component.html'
})

export class RequestAddPublisherComponent extends BaseComponent implements OnInit {

    /**
     * @var requestPublisherFormGroup
     */
    public requestPublisherFormGroup: FormGroup;

    public formId = "requestPublisherForm";

    public coverPageUploadOptions: UploadFileOptionsInterface;

    public certificatePageUploadOptions: UploadFileOptionsInterface;

    /**
     * Busy
     */
    protected busy: boolean;

    // public publisher: Publisher;

    public thumbUrl = "";

    protected avatarSpinner: Spinner;

    public permissionGroupPermissionOptions: PermissionGroupPermissionOptions = new PermissionGroupPermissionOptions();
    /**
     * Constructor
     * @param {Injector} injector
     * @param {MeService} service
     * @param {AuthService} authService
     */
    public constructor(injector: Injector, protected service: RequestAddPublisherService, protected authService: AuthService) {
        super(injector);
    }

    public avatarUploadStart ($event: any) {
        this.avatarSpinner = this.ajaxSpinner.showSpinner('avatar-container');
    }
    /**
     * Image upload response
     * @param $event
     */
    public avatarUploadSuccess($event: ServerResponse) {
        this.avatarSpinner.hide();
        if ($event.status.code === 'ok') {
            this.requestPublisherFormGroup.controls['image_url'].setValue($event.body.path);
            this.thumbUrl = $event.body.path;
        } else {
            this.showErrorToast($event.body.file.pop());
        }
    }

    protected setUploadOptions() {
        this.coverPageUploadOptions = {
          title: 'Logo Image',
          instantUpload: true,
          cancellable: false,
          disabledOnComplete: true,
          inputId: 'logo_url',
          hidden: false,
          uploadInputConfig: {
            type: 'uploadAll',
            url: this.service.getBaseApiUrl() + '/upload-resources',
            headers: {'Authorization': 'Bearer ' + this.session.getToken()},
            method: 'POST',
            fieldName: 'file',
            data: {'type': 'image'},
          }
	 };

	  this.certificatePageUploadOptions = {
            title: 'certificate',
            instantUpload: true,
            cancellable: false,
            disabledOnComplete: true,
            inputId: 'certificate_url',
            hidden: false,
            uploadInputConfig: {
              type: 'uploadAll',
              url: this.service.getBaseApiUrl() + '/upload-resources',
              headers: {'Authorization': 'Bearer ' + this.session.getToken()},
              method: 'POST',
              fieldName: 'file',
              data: {'type': 'image'},
            }
          };
      }



    /**
     * On init event
     */
    public ngOnInit() {
        this.initRequestForm();
        // this.getAuthUserDetail();
        this.setUploadOptions();
        this.setPageTitle('mod_manage.mod_profile.page_title');

    }

    public onFileUploadComplete (event: ServerResponse, formControlName: string) {
        this.requestPublisherFormGroup.controls[formControlName].setValue(event.body.path);
    }

    public onCertificateUploadComplete (event: ServerResponse, formControlName: string) {
        this.requestPublisherFormGroup.controls[formControlName].setValue(event.body.path);
      }
    // public getAuthUserDetail() {
    //     const spinner: Spinner = this.ajaxSpinner.showSpinner();
    //     this.authService.getAuthUser().subscribe((d: User) => {
    //         this.me = d;
    //         this.thumbUrl = this.me.thumb_url;
    //         this.userFormGroup.patchValue(d);
    //         this.userFormGroup.updateValueAndValidity();
    //         spinner.hide();
    //     }, ( ) =>  {
    //         spinner.hide();
    //     });
    // }

    /**
     * Init profile form
     */
    protected initRequestForm() {
        this.requestPublisherFormGroup = this.formBuilder.group({
            title: ['',Validators.required],
            street: ['', [Validators.compose([Validators.required])]],
            city: ['', Validators.required],
            phone_number: ['',Validators.required],
            fax_number: [''],
            email: ['',Validators.required],
	    logo_url: [''],
	    certificate_url: ['']
        });
    }

    /**
     * Open change password modal
     */
    // public openChangePasswordModal() {
    //     this.nicoCtrl.create(EditPasswordComponent, {
    //         showModalHeader: false,
    //         showCrossButton: false,
    //         showModalFooter: false,
    //         modalClass: 'custom-modal',
    //         htmlTemplateAsIs: true

    //     } ).present();
    // }




    public save (): any {
        if (this.busy) {
            return;
        }
        this.busy = true;
        const spinner: Spinner = this.ajaxSpinner.showSpinner();
        this.service.requestPublisher(this.requestPublisherFormGroup.value)
            .subscribe(() => {
                this.busy = false;
                spinner.hide();
                this.showSuccessToast('Request has been sent, you will be contact soon.');

                this.router.navigate(['/manage/publishers/']);
            }, (d: ServerResponse) => {
                this.busy = false;
                spinner.hide();

                if (d.status.statusCode === 417) {
                    this.validationMessenger.attach(this.formId, d.body);
                }
            });
    }

    // back () {
    //     this.location.back();
    // }

}

