import {BaseComponent} from "../../../../../../../system/controllers/BaseComponent";
import {Component, Injector, OnInit} from "@angular/core";
import {PublisherPrefixService} from "../../../../services/publisher-prefix.service";
import {UrlParamsInterface} from "../../../../../../../shared/enums/UrlParamsInterface";
import {BasePublisherPrefixInterface} from "../../../../../../../shared/base/contituents/publisher/interfaces/BasePublisherPrefixInterface";
import {AddPrefixComponent} from "./components/add-prefix.component";
import {environment} from "../../../../../../../../environments/environment";
import { PublisherService } from "../../../../services/publisher.service";
// import {Publisher} from ".../../../../models/publisher";
import { Publisher } from "../../../../models/Publisher";
import {BasePublisher} from "../../../../../../../shared/base/contituents/publisher/models/BasePublisher";

@Component({
  selector: 'app-publisher-prefix',
  templateUrl: 'prefixes.component.html'
})
export class PrefixesComponent extends BaseComponent implements OnInit {

  public isbnPrefix: string;
  public urlParams: UrlParamsInterface = {page: 1, sort_by: 'prefix', sort_order: 'desc'};
  public publisherService : PublisherService;
  public publisherModel:any;
  
  
  constructor(injector: Injector) {
    super(injector);
    this.service = injector.get(PublisherPrefixService);
    this.publisherService = injector.get(PublisherService);
    this.isbnPrefix = environment.country_isbn_identifier;
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.setPageTitle("Prefixes");
    // console.log(this.activatedRoute.parent.params);
    const subscription = this.activatedRoute.parent.params.subscribe((params: any) => {
      (<PublisherPrefixService> this.service).generateResourceUrl({publisherId: params.id});
      this.publisherService.find(params.id).subscribe((model:Publisher)=>{
          this.publisherModel = model.title;
      });
      this.getList();
      if (subscription) {
        subscription.unsubscribe();
      }
    });
  }

  /**
   * Edit item
   * @param item
   */
  public openCreateModel(item?: BasePublisherPrefixInterface) {
    this.nicoCtrl.create(AddPrefixComponent, {
      htmlTemplateAsIs: true,
      data: {model: item},

      modalClass: 'custom-modal custom-modal-md',
      onOkayProcessComplete: () => {
        this.getList();
      }
    }).present();
  }

}
