import { Component, Injector, OnDestroy, OnInit } from '@angular/core';
import { BaseComponent } from '../../../../../system/controllers/BaseComponent';
import { RequestPublisherOwnerService } from '../../services/request-publisher-owner.service';

@Component({
  selector: 'app-list-request-owner',
  templateUrl: './list-request-owner.component.html'
})

export class ListRequestOwnerComponent extends BaseComponent implements OnInit, OnDestroy {

  protected currentService: RequestPublisherOwnerService;

  /**
   * Constructor
   * @param injector
   * @param service
   */
  constructor(injector: Injector, protected service: RequestPublisherOwnerService) {
    super(injector);
  }

  /**
   * On init hook
   */
  public ngOnInit() {
    super.ngOnInit();
    this.setPageTitle('Request publisher Owner');
    this.getList();
  }

  public requestOwnerAccepted(item: number) {
    this.appService.showConfirmDialog({
      message: "Are you sure you want to accept the request?",
      onConfirm: () => {
        const spinner = this.ajaxSpinner.showSpinner();
        const subscription = this.service.acceptRequest(item).subscribe(() => {
          if (subscription) {
            this.showSuccessToast('Request has been successfully accepted.');
            subscription.unsubscribe();
            spinner.hide();
          }
          this.getList();
        }, () => {
          if (subscription) {
            subscription.unsubscribe();
            spinner.hide();
          }
        });
      }
    }
    )
  };


}
