import { Component, Injector, OnDestroy, OnInit, TemplateRef, ViewChild } from '@angular/core';
import { NicoModalController } from 'src/app/system/components/modal/NicoModalController';
import { AbstractNicoModalComponent } from "../../../../../system/components/modal/AbstractNicoModalComponent";
import { AdvancedSelectConfigInterface } from "../../../../../system/components/advanced-select/advanced-select.component";
import { FormGroup, Validators } from '@angular/forms';
import { PublisherService } from '../../services/publisher.service';
import { Publisher } from "../../models/Publisher";
import { User } from '../../../me/models/User';
import { Spinner } from "../../../../../system/services/AjaxSpinner";
import {UploadFileOptionsInterface} from "../../../../../shared/upload-file-component/upload-file.options.interface";
import {ServerResponse} from "../../../../../system/responses/ServerResponse";


@Component({
  selector: 'app-assign-publisher-owner',
  templateUrl: './assign-publisher-owner.component.html',
  styleUrls: []
})
export class AssignPublisherOwnerComponent extends AbstractNicoModalComponent implements OnInit, OnDestroy {

  /**
   * The id for video add form
   * @var string
   */
  protected busySaving = false;

  public formId = "assign-publisher-owner-form";

  public formGroup: FormGroup;

  public modalTitle = "Assign Publiser Owner";

  public isbnAddOn: string = null;

  public publisherFetchUrl = "";

  public config: AdvancedSelectConfigInterface = {};

  public publisherModel;

  protected dismisser: Function;

  public model: Publisher;

  public service: PublisherService;

  protected user: User;

  public letterUploadOptions: UploadFileOptionsInterface;
  /**
   * Constructor
   * @param injector
   * @param modalController
   */
  constructor(injector: Injector, protected modalController: NicoModalController) {
    super(injector);
    this.service = injector.get(PublisherService);
  }

  @ViewChild('publisherSelectItemTemplate') publisherSelectItemTemplate: TemplateRef<any>;
  @ViewChild('emptySelectionTemplate') publisherEmptyItemTemplate: TemplateRef<any>;

  protected setUploadOptions() {
    this.letterUploadOptions = {
      title: 'Application Letter',
      instantUpload: true,
      cancellable: false,
      disabledOnComplete: true,
      inputId: 'application_letter',
      hidden: false,
      uploadInputConfig: {
        type: 'uploadAll',
        url: this.service.getBaseApiUrl() + '/upload-resources',
        headers: {'Authorization': 'Bearer ' + this.session.getToken()},
        method: 'POST',
        fieldName: 'file',
        data: {'type': 'image_doc'},
      }
    };
  }
  public ngOnInit() {
    super.ngOnInit();
    // this.setPageTitle('mod_manage.mod_publishers.add_page_title');
    // this.modalTitle = 'mod_manage.mod_publishers.add_page_title';
    this.publisherFetchUrl = this.service.getBaseApiUrl() + '/publisher/ownership';
    this.setAdvSelectConfig();

    this.formGroup = this.formBuilder.group({
      publisher: ['', Validators.compose([Validators.required])],
      application_letter:['']
    });

    this.setUploadOptions();

  }

  protected setAdvSelectConfig() {
    this.config.itemTemplate = this.publisherSelectItemTemplate;
    this.config.equalityCheckProperty = 'id';
    this.config.actionButtonEnabled = false;
    this.config.disableEmptyField = false;
    this.config.selectInfoLabel = "Select publisher";
    this.config.emptySelectionTemplate = this.publisherEmptyItemTemplate;
  }

  /**
   * On form submit
   */
  public save(): any {

    this.user = <User>this.session.getAuthUser();
    console.log(this.formGroup.value.application_letter);
    const data = {
      publisher: this.formGroup.value.publisher.id,
      user: this.user.id,
      application_letter: this.formGroup.value.application_letter
    };
    const spinner: Spinner = this.ajaxSpinner.showSpinner();
    this.service.requestPublisherOwnership(data)
      .subscribe(() => {
        spinner.hide();
        this.showSuccessToast('Request has been sent, you will be contacted soon.');
        //this.formGroup.reset();
        this.dismisser();
      }, () => {
        spinner.hide();
      });

  }

  /**
   * On cancle
   */

  // public cancel() {
  //  // this.formGroup.reset();
  //   this.dismisser();
  // }

  public onFileUploadComplete (event: ServerResponse, formControlName: string) {

    this.formGroup.controls[formControlName].setValue(event.body.path);
  }

  public onPublisherChange() {
//     if (this.publisherModel) {
//       this.urlParams.publisher = this.publisherModel.id;
//     } else {
//       delete this.urlParams.publisher;
//     }
//     this.getList();
  }
}
