import {Injector, OnInit} from '@angular/core';
import {PublisherService} from '../services/publisher.service';
import {FormGroup, Validators} from '@angular/forms';
import {UploadFileOptionsInterface} from '../../../../shared/upload-file-component/upload-file.options.interface';
import {ServerResponse} from '../../../../system/responses/ServerResponse';
import {Observable, Subject} from 'rxjs';
import {AbstractNicoModalComponent} from "../../../../system/components/modal/AbstractNicoModalComponent";

export abstract class AbstractPublisherCreateComponent extends AbstractNicoModalComponent implements OnInit {

  protected service: PublisherService;

  public formGroup: FormGroup;

  public thumbUploadOptions: UploadFileOptionsInterface = null;

  protected busySaving: boolean = false;

    /**
   * Form id
   */
  public formId = 'edit-form';

  /**
   * constrcutor
   * @param injector
   */
  protected constructor(injector: Injector) {
    super(injector);
    this.service = injector.get(PublisherService);

  }

  public onFileUploadComplete (event: ServerResponse, formControlName: string) {
    this.formGroup.controls[formControlName].setValue(event.body.path);
  }

  protected setUploadOption() {
    this.thumbUploadOptions = {
      title: 'Logo',
      instantUpload: true,
      cancellable: false,
      disabledOnComplete: true,
      hidden: false,
      uploadInputConfig: {
        type: 'uploadAll',
        url: this.service.getBaseApiUrl() + '/upload-resources',
        headers: {'Authorization': 'Bearer ' + this.session.getToken()},
        method: 'POST',
        fieldName: 'file',
        data: {'type': 'image'},
      }
    };
  }


  /**
   * Lifecycle event
   */
  ngOnInit() {
    super.ngOnInit();
    this.setUploadOption();
    this.formGroup = this.formBuilder.group({
      title: ['', Validators.compose([Validators.required])],
      street: ['', Validators.compose([Validators.required])],
      city: [''],
      phone_number: [''],
      fax_number: [''],
      email: ['', Validators.compose([Validators.required])],
      logo_url: [''],
    });
    if (this.data.model) {
      this.formGroup.patchValue(this.data.model);
    }
  }

  /**
   * Save the form data
   */
  public saveForm(): Observable<any> {
    if (this.busySaving) {
      return;
    }
    const spinner = this.ajaxSpinner.showSpinner();
    this.busySaving = true;
    const observable = new Subject();
    this.service.save(this.formGroup.value, this.data.model ? this.data.model.id : null).subscribe(() => {
      spinner.hide();
      this.busySaving = false;
      return observable.next();
    }, (response: ServerResponse) => {
      spinner.hide();
      this.busySaving = false;
      if (!response.status.messageShown) {
        this.showErrorToast(response.status.message);
      }
      if (response.status.statusCode === 417) {
        this.validationMessenger.attach(this.formId, response.body);
      }
      return observable.error(response);
    });
    return observable;
  }

  /**
   * Cancel form
   */

  public cancelForm() {
    this.dismisser();
  }
}
