import { EventEmitter, Injectable } from '@angular/core';
import { BaseService } from "../../../../system/services/BaseService";
import { NicoHttp } from "../../../../system/requests/NicoHttp";
import {NoticeModel} from "../models/notice";
import {environment} from "../../../../../environments/environment";
import {Observable} from "rxjs";
import { BaseResourceInterface } from 'src/app/system/datamodels/BaseResourceInterface';

@Injectable()
export class NoticeService extends BaseService {

    /**
     * The resource
     * @type {string}
     */
    protected resourceName: string = 'notices';
    /**
     * Base resource url
     * @type {string}
     */
    protected resourceBaseUrl: string = '';
    /**
     *
     * @type {User}
     */
    protected resource: NoticeModel;

    /**
     * Constructor
     * @param http
     */
    public constructor(protected http: NicoHttp) {
        super(http, environment);
        this.resource = new NoticeModel();
        this.setResourceName(this.resourceName);
    }


    public createNotice(input: BaseResourceInterface): Observable<any> {
      return this.http.post(this.getBaseApiUrl() + '/notices/create-notice', input);
    }
    
    public delete (data: BaseResourceInterface ): Observable<any> {
      return this.http.delete(this.getBaseApiUrl() + '/notices/' + data.id, null);
    }

  }


