import { Component, Injector, OnDestroy, OnInit, } from '@angular/core';
import { BaseComponent } from "../../../../../system/controllers/BaseComponent";
import { AuthService } from '../../../../../shared/auth/services/auth.service';
import { ServerResponse } from "../../../../../system/responses/ServerResponse";
import { NoticeService } from '../../services/notice.service';

@Component({
  selector: 'app-notice-view',
  templateUrl: './notice-view.component.html'
})
export class NoticeViewComponent extends BaseComponent implements OnInit {


  /**
   * Constructor
   * @param injector
   * @param modalController
   */
  constructor(injector: Injector, protected service: NoticeService, protected authService: AuthService) {
    super(injector);
  }

  /**
   *  Oninit lifecycle hook
   */
  public ngOnInit() {
    super.ngOnInit();
    this.setPageTitle('List Notice');
    this.getList();
  }

  public delete(item:any) {
      this.appService.showConfirmDialog({
        message: "Are you sure you want to delete?",
        onConfirm: () => {
          const spinner = this.ajaxSpinner.showSpinner();
          const subscription = this.service.delete(item).subscribe(() => {
            if (subscription) {
              this.showSuccessToast('Request has been successfully deleted.');
              subscription.unsubscribe();
              spinner.hide();
            }
            this.router.navigate(['/manage/notices']);
          }, () => {
            if (subscription) {
              subscription.unsubscribe();
              spinner.hide();
            }
          });
        }
      });
    }

    public editNotice(item:any) {
      console.log('d');
      this.router.navigate(['manage/notices/edit/'+item.id]);
    }


}
