"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.NoticeCreateComponent = void 0;
var core_1 = require("@angular/core");
var forms_1 = require("@angular/forms");
var BaseComponent_1 = require("../../../../../system/controllers/BaseComponent");
var NoticeCreateComponent = /** @class */ (function (_super) {
    __extends(NoticeCreateComponent, _super);
    /**
     * Constructor
     * @param injector
     * @param modalController
     */
    function NoticeCreateComponent(injector, service, authService) {
        var _this = _super.call(this, injector) || this;
        _this.service = service;
        _this.authService = authService;
        /**
         * The id for video add form
         * @var string
         */
        _this.formId = "add-notice-form";
        return _this;
    }
    /**
     *  Oninit lifecycle hook
     */
    NoticeCreateComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.setPageTitle('Create Notice');
        this.initRequestForm();
    };
    NoticeCreateComponent.prototype.initRequestForm = function () {
        this.noticeFormGroup = this.formBuilder.group({
            title: ['', forms_1.Validators.required],
            body: ['', forms_1.Validators.required]
        });
    };
    /**
     * On form submit
     */
    NoticeCreateComponent.prototype.save = function () {
        var _this = this;
        if (this.busy) {
            return;
        }
        this.busy = true;
        var spinner = this.ajaxSpinner.showSpinner();
        this.service.save(this.noticeFormGroup.value, this.model ? this.model.id : null, null, false)
            .subscribe(function (res) {
            _this.busy = false;
            spinner.hide();
            _this.showSuccessToast('Notice has been saved.');
            _this.router.navigate(['/manage/notices/']);
        }, function (d) {
            _this.busy = false;
            spinner.hide();
            if (d.status.statusCode === 417) {
                _this.validationMessenger.attach(_this.formId, d.body);
            }
        });
    };
    NoticeCreateComponent.prototype.onRouteParamInitialized = function () {
        _super.prototype.onRouteParamInitialized.call(this);
        this.setModelIfEditPage();
    };
    NoticeCreateComponent.prototype.setModelIfEditPage = function () {
        var _this = this;
        if (this.routeParams.get('id')) {
            var spinner_1 = this.ajaxSpinner.showSpinner();
            this.service.find(this.routeParams.get('id'))
                .subscribe(function (model) {
                spinner_1.hide();
                _this.model = model;
                _this.noticeFormGroup.patchValue(_this.model);
                _this.pageTitle.setTitle('Edit Notice');
            }, function (error) {
                spinner_1.hide();
                _this.router.navigate(['manage/notices']);
            });
        }
    };
    NoticeCreateComponent = __decorate([
        core_1.Component({
            selector: 'app-notice-create',
            templateUrl: './notice-create.component.html',
            styleUrls: ['./notice-create.component.scss']
        })
    ], NoticeCreateComponent);
    return NoticeCreateComponent;
}(BaseComponent_1.BaseComponent));
exports.NoticeCreateComponent = NoticeCreateComponent;
