import {Component, Injector} from "@angular/core";
import {BaseComponent} from "../../../../../system/controllers/BaseComponent";
import {IsbnApplicationService} from "../../../../../shared/services/isbn-application.service";
import {AppLanguageProviderService} from "../../../../../shared/services/app-language-provider.service";
import {IsbnApplication} from "../../models/IsbnApplication";
import {ServerResponse} from "../../../../../system/responses/ServerResponse";
import { Helper } from "src/app/system/utilities/Helper";
import {BaseIssuedISBN} from "../../../../../shared/base/contituents/isbn-application/models/BaseIssuedISBN";
import {IsbnIssueModalComponent} from "../../../../../shared/isbn-issue-modal/isbn-issue-modal.component";
@Component({
  selector: 'app-isbn-application-show',
  templateUrl: './isbn-application-show.component.html'
})
export class IsbnApplicationShowComponent extends BaseComponent {

  public canEdit:boolean;
  
  constructor(injector: Injector) {
    super(injector);
    this.service = injector.get(IsbnApplicationService);
  }

  public onRouteParamInitialized() {
    super.onRouteParamInitialized();
    this.getItem();
    this.canEdit = this.authUser.can('isbn_applications.update') 
  }

  protected getItem() {
    if (this.routeParams.get('id')) {
      const spinner = this.ajaxSpinner.showSpinner();
      this.service.find(this.routeParams.get('id'))
        .subscribe((model: IsbnApplication) => {
          spinner.hide();
          this.model = model;
        }, (error: ServerResponse) => {
          spinner.hide();
          this.router.navigate(['manage/isbn-applications']);
        });
    }

  }

  public showIsbnModalBox (application: IsbnApplication, isbn?: BaseIssuedISBN) {
    this.nicoCtrl.create(IsbnIssueModalComponent, {
      htmlTemplateAsIs: true,
      data: {application: application, isbn: isbn, isbnAddOn: null},
      onOkayProcessComplete: ( model: any, message: any) => {
        this.showSuccessToast(message);
        this.getList();
      }
    }).present();
  }

  public getBack()
  {
    Helper.setStorage('getFiltered',true);
    this.router.navigate(['manage/isbn-applications']);
  }

}
