import {Component, Injector, OnInit, TemplateRef, ViewChild} from "@angular/core";
import {BaseComponent} from "../../../../../system/controllers/BaseComponent";
import {IsbnApplicationService} from "../../../../../shared/services/isbn-application.service";
import {
  ActionFlyMenuOptionsInterface,
  FlyMenuActionEnum,
} from "../../../../../system/components/action-fly-menu/action-fly-menu.component";
import {BaseResourceInterface} from "../../../../../system/datamodels/BaseResourceInterface";
import {IsbnIssueModalComponent} from "../../../../../shared/isbn-issue-modal/isbn-issue-modal.component";
import {environment} from "../../../../../../environments/environment";
import {BaseIssuedISBN} from "../../../../../shared/base/contituents/isbn-application/models/BaseIssuedISBN";
import {BaseIsbnApplication} from "../../../../../shared/base/contituents/isbn-application/models/BaseIsbnApplication";
import {AdvancedSelectConfigInterface} from "../../../../../system/components/advanced-select/advanced-select.component";
import {AuthorsListComponent} from "../../../../../shared/authors-list-component/authors-list.component";
import {Observable, Subject} from "rxjs";
import {ServerResponse} from '../../../../../system/responses/ServerResponse';
import { Helper } from "src/app/system/utilities/Helper";
import {debounceTime, distinctUntilChanged, map} from 'rxjs/internal/operators';

@Component({
  selector: 'app-isbn-application-list',
  templateUrl: './isbn-application-list.component.html'
})
export class IsbnApplicationListComponent extends BaseComponent implements  OnInit {

  @ViewChild('publisherSelectItemTemplate') publisherSelectItemTemplate: TemplateRef<any>;
  @ViewChild('emptySelectionTemplate') publisherEmptyItemTemplate: TemplateRef<any>;

  /**
   * @var config
   */
  public config: AdvancedSelectConfigInterface = {};

  public publisherModel;

  public publisherVal;

  public receivedModel = null;

  public isbnStatusModel = null;

  public publisherFetchUrl = "";

  constructor (injector: Injector) {
    super(injector);
    this.service = injector.get(IsbnApplicationService);
  }

  protected setAdvSelectConfig() {
    this.config.itemTemplate = this.publisherSelectItemTemplate;
    this.config.equalityCheckProperty = 'id';
    this.config.actionButtonEnabled = false;
    this.config.disableEmptyField = false;
    this.config.selectInfoLabel = "Select publisher";
    this.config.emptySelectionTemplate = this.publisherEmptyItemTemplate;


  }

  ngOnInit(): void {
    super.ngOnInit();
    this.publisherFetchUrl = this.service.getBaseApiUrl() + '/publishers';
    this.setAdvSelectConfig();
    this.pageTitle.setTitle("ISBN applications");

    if (Helper.getStorage('getFiltered')){
      console.log(Helper.getStorage('publisherSearch'));
      if(Helper.getStorage('publisherSearch')) {
        this.urlParams.publisher = Helper.getStorage('publisherSearch');
        this.http.get(`${this.publisherFetchUrl}/${ Helper.getStorage('publisherSearch')}`).pipe(map((res: ServerResponse) => {
          this.publisherModel =  res.body;
          return res.body;
        })).subscribe((d: any) => {
        }, (d: any) => {
        });
      }
      if(Helper.getStorage('receivedSearch')) {
        this.urlParams.received = Helper.getStorage('receivedSearch');
        this.receivedModel = Helper.getStorage('receivedSearch');
      }
      if(Helper.getStorage('titleSearch')) {
        this.urlParams.title = Helper.getStorage('titleSearch');
      }

      if(Helper.getStorage('isbnStatus')) {
        this.urlParams.isbnStatus = Helper.getStorage('isbnStatus');
        this.isbnStatusModel = Helper.getStorage('isbnStatus');
      }
      // Helper.removeStorage('getFiltered');

      
    }
    

    this.getList();
  }
  public getList(showToast?: boolean): Observable<any> {
    const subject = new Subject();
    super.getList().subscribe((items: any) => {      
      for (let i = 0; i < items.length; i++ ) {
        const item = items.getItem(i);
        const flyMenuAddOn = [];
        flyMenuAddOn.push({
          name: 'show_more', label: 'Show more...', active: true
        });
        // tslint:disable-next-line:triple-equals
        if (item.received_status != 1 && this.authUser.can('isbn_applications.mark_received')) {
          flyMenuAddOn.push ({name: 'mark_as_received', label: 'Mark as received', active: true, });
	  }

	  if (item.received_status == 1) {
          flyMenuAddOn.push ({name: 'mark_as_not_received', label: 'Mark as Not received', active: true, });
        }
        if (!item.issued_isbn && this.authUser.can('isbn.create')) {
          flyMenuAddOn.push ({name: 'issue_isbn', label: 'Issue ISBN', active: true, });
        }

        item.flyMenuAddOn = flyMenuAddOn;
        item.flyMenuConfig =  {
          // disableEditItem: !this.authUser.can('isbn_applications.update') || item.issued_isbn ,
          disableEditItem: !this.authUser.can('isbn_applications.update') ,

          disableRemoveItem: !this.authUser.can('isbn_applications.delete'),
          disableStatusItem: true
        };

      }
    });
    return subject;
  }

  public onPublisherChange () {
    if(Helper.getStorage('getFiltered') && Helper.getStorage('publisherSearch'))
    {
      this.urlParams.publisher = Helper.getStorage('publisherSearch');
    }else{
      if (this.publisherModel) {
        this.urlParams.publisher = this.publisherModel.id;
        Helper.setStorage('publisherSearch', this.publisherModel.id);
      } else {
        delete this.urlParams.publisher;
        Helper.removeStorage('publisherSearch');
      }
    }
    Helper.removeStorage('getFiltered');
    Helper.removeStorage('publisherSearch');

    this.getList();
  }
  
  public onReceivedModelChange () {
      if (isNaN(this.receivedModel)) {
        delete this.urlParams.received;
        Helper.removeStorage('receivedSearch');
      } else {
        this.urlParams.received = this.receivedModel;
        Helper.setStorage('receivedSearch', this.receivedModel);
      }
    this.getList();
    }

  public onIsbnStatusModelChange () {
    if (this.isbnStatusModel == "null") {
      delete this.urlParams.isbnStatus;
      Helper.removeStorage('isbnStatus');
    } else {
      this.urlParams.isbnStatus = this.isbnStatusModel;
      Helper.setStorage('isbnStatus', this.isbnStatusModel);
    }
  this.getList();
  }
  /**
   * Edit the item
   * @param item
   */
  public editItem(item: BaseResourceInterface) {
    this.router.navigate([`manage/isbn-applications/${item.id}/edit`]);
  }

  public showIsbnModalBox (application: BaseIsbnApplication, isbn?: BaseIssuedISBN) {
    this.nicoCtrl.create(IsbnIssueModalComponent, {
      htmlTemplateAsIs: true,
      data: {application: application, isbn: isbn, isbnAddOn: null},
      onOkayProcessComplete: ( model: any, message: any) => {
        this.showSuccessToast(message);
        this.getList();
      }
    }).present();
  }

  public onFlyMenuAction(evt: FlyMenuActionEnum | any, item: any) {
    super.onFlyMenuAction(evt, item);
    if (evt === 'mark_as_received') {
        let markedValue = {'value': 1};
        const subscription = (<IsbnApplicationService> this.service).markAsReceived(item, markedValue).subscribe(() => {
        if (subscription) {
          subscription.unsubscribe();
        }
        this.items.forEach((itm: any) => {
          if (itm.id === item.id) {
	  item.received_status = 1;

	  item.flyMenuAddOn.forEach((i:any) => {
              if(i.name == 'mark_as_received')
              {
                i.name = 'mark_as_not_received';
                i.label = 'Mark as not received';
              }
            });
          }
        });
      }, ( ) => {
        if (subscription) {
          subscription.unsubscribe();
        }
	});
     } else if (evt === 'mark_as_not_received') {
        let markedValue = {'value': 0};
        const subscription = (<IsbnApplicationService> this.service).markAsReceived(item, markedValue).subscribe(() => {
          if (subscription) {
            subscription.unsubscribe();
          }
          this.items.forEach((itm: any) => {
            if (itm.id === item.id) {
	    item.received_status = 0;

	    item.flyMenuAddOn.forEach((i:any) => {
                if(i.name == 'mark_as_not_received')
                {
                  i.name = 'mark_as_received';
                  i.label = 'Mark as Not receive';
                }
              });
            }
          });
        }, ( ) => {
          if (subscription) {
            subscription.unsubscribe();
          }
        });
    } else if (evt === 'issue_isbn') {
      this.showIsbnModalBox (item);
    } else if (evt === 'show_more') {
      this.router.navigate(['manage/isbn-applications/' + item.id + '/show']);
    }
  }

  public editIsbn(application: BaseIsbnApplication, isbn: BaseIssuedISBN ) {
    this.showIsbnModalBox(application, isbn);
  }

  public authorListShowMore (item: any) {
    this.nicoCtrl.create(AuthorsListComponent, {
      data: {items: item.authors},
      htmlTemplateAsIs: true
    }).present();
  }


}
