import {NgModule} from '@angular/core';
import {RouterModule} from '@angular/router';
import {IsbnApplicationComponent} from "./isbn-application.component";
import {IsbnApplicationListComponent} from "./pages/isbn-application-list/isbn-application-list.component";
import {IsbnApplicationShowComponent} from "./pages/isbn-application-show/isbn-application-show.component";
import {IsbnApplicationCreateComponent} from "./pages/isbn-application-create/isbn-application-create.component";

@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: IsbnApplicationComponent,
        children: [
          {
            path: '',
            component: IsbnApplicationListComponent,
          },
          {
            path: ':id/show',
            component: IsbnApplicationShowComponent,
          },
          {
            path: ':id/edit',
            component: IsbnApplicationCreateComponent,
          },
          {
            path: 'create',
            component: IsbnApplicationCreateComponent
          }
        ]
      },
    ])
  ],
  exports: [RouterModule]
})
export class IsbnApplicationRoutingModule {
}
