import {Component, Injector, OnInit} from '@angular/core';
import {BaseComponent} from "../../../system/controllers/BaseComponent";
import {RouterOutlet} from '@angular/router';
import {slideInAnimation} from '../../../system/animations';

@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss'],
  animations: [slideInAnimation]
})
export class DashboardComponent extends  BaseComponent implements OnInit {

  constructor(protected  injector: Injector) {
    super(injector);
  }

  ngOnInit() {
      this.setPageTitle('Home');
      this.router.navigate(['/manage/publishers']);
  }

  /**
   *  the Method that is called after route param is initialized
   *  If you need to grab something from route and then initialize component. Define them here.
   *  Note, this method will be called every-time if url is changed. So use it wisely.
   */
  public onRouteParamInitialized() {

  }

  prepareRoute(outlet: RouterOutlet) {
    return outlet && outlet.activatedRouteData;
  }
}
