import { ElementRef } from '@angular/core';
import { Observable } from 'rxjs';
export declare type SmoothScrollEaseFunc = (t: number, s: number, c: number, d: number) => number;
export interface SmoothScrollOptions {
    top?: number;
    left?: number;
    offsetTop: number;
    offsetLeft: number;
    duration: number;
    scrollFunc: (top: number, left: number) => void;
    easeFunc: SmoothScrollEaseFunc;
}
export interface ScrollToOptions {
    top?: number;
    left?: number;
    duration?: number;
    easeFunc?: SmoothScrollEaseFunc;
}
export declare class SmoothScroll {
    private _platform;
    private readonly view;
    constructor(_platform: Object, el: ElementRef);
    private scrollFunc;
    scrollTo(options: ScrollToOptions): Observable<void>;
    scrollToElement(selector: string, offset?: number, duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollXTo(left: number, duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollYTo(top: number, duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollToTop(duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollToBottom(duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollToRight(duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollToLeft(duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
}
export declare function smoothScroll(options: SmoothScrollOptions): Promise<void>;
export declare function easeInOutQuad(t: number, b: number, c: number, d: number): number;
export declare function easeInCubic(t: number, b: number, c: number, d: number): number;
export declare function inOutQuintic(t: number, b: number, c: number, d: number): number;
