import { AfterViewInit, OnDestroy, ElementRef, ChangeDetectorRef } from '@angular/core';
import { CdkScrollable, CdkVirtualScrollViewport } from '@angular/cdk/scrolling';
import { BreakpointObserver } from '@angular/cdk/layout';
import { Observable } from 'rxjs';
import { ScrollToOptions, SmoothScroll, SmoothScrollEaseFunc } from '../smooth-scroll/smooth-scroll';
import { NgScrollbarView } from './ng-scrollbar-view';
export declare class NgScrollbar implements AfterViewInit, OnDestroy {
    private _changeDetectorRef;
    private _breakpointObserver;
    private _platform;
    /** Horizontal custom scrollbar */
    trackX: boolean;
    /** Vertical custom Scrollbar */
    trackY: boolean;
    /** Scrollbar visibility */
    shown: 'hover' | 'always' | 'native';
    /** Auto update scrollbars on content changes (Mutation Observer) */
    autoUpdate: boolean;
    /** Viewport class */
    viewClass: string;
    /** Scrollbars class */
    barClass: string;
    /** Scrollbars thumbnails class */
    thumbClass: string;
    /** The smooth scroll duration when a scrollbar is clicked */
    scrollToDuration: number;
    /** Compact mode */
    compact: boolean;
    /** Invert vertical scrollbar position, if set the scrollbar will be on the right */
    invertY: boolean;
    /** Invert horizontal scrollbar position, if set the scrollbar will go the top */
    invertX: boolean;
    /** Disable custom scrollbars on specific breakpoints */
    disableOnBreakpoints: string[];
    /** Disable custom scrollbars and switch back to native scrollbars */
    disabled: boolean;
    private _disabled;
    /** Scrollbars ElementRef */
    verticalScrollbar: ElementRef;
    horizontalScrollbar: ElementRef;
    /** Default viewport and smoothScroll references */
    scrollViewport: CdkScrollable;
    viewSmoothScroll: SmoothScroll;
    /** Virtual viewport and smoothScroll references */
    customViewPort: NgScrollbarView;
    /** Viewport Element */
    readonly view: HTMLElement;
    readonly scrollable: CdkScrollable | CdkVirtualScrollViewport;
    readonly smoothScroll: SmoothScroll;
    readonly hideNativeScrollbars: any;
    /** Unsubscribe component observables on destroy */
    private _unsubscribe$;
    /** Observe content changes */
    private _observer;
    /** Steam that emits when scrollbar thumbnail needs to update (for internal uses) */
    private _updateObserver;
    updateObserver: Observable<{}>;
    constructor(_changeDetectorRef: ChangeDetectorRef, _breakpointObserver: BreakpointObserver, _platform: Object);
    showScrollbarY(): boolean;
    showScrollbarX(): boolean;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    /**
     * Update scrollbar thumbnail position
     */
    update(): void;
    /**
     * Enable custom scrollbar
     */
    enable(): void;
    /**
     * Disable custom scrollbar
     */
    disable(): void;
    scrollTo(options: ScrollToOptions): Observable<void>;
    scrollToElement(selector: string, offset?: number, duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollXTo(to: number, duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollYTo(to: number, duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollToTop(duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollToBottom(duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollToRight(duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
    scrollToLeft(duration?: number, easeFunc?: SmoothScrollEaseFunc): Observable<void>;
}
