import { AfterViewInit, OnDestroy, NgZone, ElementRef } from '@angular/core';
import { Observable, BehaviorSubject, Subscription } from 'rxjs';
import { NgScrollbar } from './ng-scrollbar';
export declare class NgScrollbarThumb implements AfterViewInit, OnDestroy {
    protected _parent: NgScrollbar;
    protected _platform: Object;
    protected _zone: NgZone;
    /** Scrollbar class */
    barClass: string;
    /** Scrollbar thumbnail class */
    thumbClass: string;
    /** The scroll duration when scrollbar (not the thumbnail) is clicked */
    scrollToDuration: number;
    bar: ElementRef;
    thumb: ElementRef;
    protected _minThumbSize: number;
    protected _naturalThumbSize: number;
    protected _thumbSize: number;
    protected _trackMax: number;
    protected _scrollMax: number;
    protected _currPos: number;
    protected _scroll$: Subscription;
    protected _thumbDrag$: Subscription;
    protected _updateObserver$: Subscription;
    protected _view: HTMLElement;
    protected _state: BehaviorSubject<any>;
    /** Scrollbar styles */
    readonly scrollbarStyle: Observable<any>;
    readonly thumbSize: number;
    constructor(_parent: NgScrollbar, _platform: Object, _zone: NgZone);
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    /**
     * Scrollbar click
     * @param e Mouse event
     */
    onScrollbarHolderClick(e: any): void;
    /**
     * Update scrollbar
     */
    protected updateScrollbar(): void;
    /**
     * Start vertical thumb worker
     */
    protected startThumbEvents(): Observable<any> | undefined;
    /**
     * Get scrollbar thumb size
     * @param naturalThumbSize
     * @param scrollMax
     */
    protected scrollBoundaries(naturalThumbSize: number, scrollMax: number): number;
    protected updateState(state: any): void;
}
