import { Directive, Inject, PLATFORM_ID, ElementRef, NgModule, Optional, Component, ChangeDetectionStrategy, ChangeDetectorRef, Input, ViewChild, ContentChild, forwardRef, NgZone } from '@angular/core';
import { isPlatformBrowser, DOCUMENT, CommonModule } from '@angular/common';
import { ScrollingModule, CdkVirtualScrollViewport, CdkScrollable } from '@angular/cdk/scrolling';
import { BreakpointObserver, Breakpoints, LayoutModule } from '@angular/cdk/layout';
import { Directionality, BidiModule } from '@angular/cdk/bidi';
import { supportsScrollBehavior } from '@angular/cdk/platform';
import { from, of, animationFrameScheduler, fromEvent, Subject, Subscription, BehaviorSubject } from 'rxjs';
import { tap, takeUntil, throttleTime, debounceTime, pluck, mergeMap } from 'rxjs/operators';
import { __assign, __extends } from 'tslib';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var SmoothScroll = /** @class */ (function () {
    function SmoothScroll(_platform, el) {
        this._platform = _platform;
        this.view = el.nativeElement;
    }
    /**
     * @private
     * @param {?} left
     * @param {?} top
     * @return {?}
     */
    SmoothScroll.prototype.scrollFunc = /**
     * @private
     * @param {?} left
     * @param {?} top
     * @return {?}
     */
    function (left, top) {
        if (supportsScrollBehavior()) {
            this.view.scrollTo({ top: top, left: left });
        }
        else {
            this.view.scrollTop = top;
            this.view.scrollLeft = left;
        }
    };
    /**
     * @param {?} options
     * @return {?}
     */
    SmoothScroll.prototype.scrollTo = /**
     * @param {?} options
     * @return {?}
     */
    function (options) {
        var _this = this;
        // Avoid SSR error
        if (isPlatformBrowser(this._platform)) {
            /** @type {?} */
            var scrollFunc = (/**
             * @param {?} left
             * @param {?} top
             * @return {?}
             */
            function (left, top) {
                if (supportsScrollBehavior()) {
                    _this.view.scrollTo({ top: top, left: left });
                }
                else {
                    _this.view.scrollTop = top;
                    _this.view.scrollLeft = left;
                }
            });
            if (options.duration) {
                /** @type {?} */
                var smoothScrollOptions = {
                    top: options.top,
                    left: options.left,
                    duration: options.duration,
                    easeFunc: options.easeFunc || easeInOutQuad,
                    offsetTop: this.view.scrollTop,
                    offsetLeft: this.view.scrollLeft,
                    scrollFunc: scrollFunc
                };
                return from(smoothScroll(smoothScrollOptions));
            }
            this.scrollFunc(options.left, options.top);
        }
        return of();
    };
    /**
     * @param {?} selector
     * @param {?=} offset
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    SmoothScroll.prototype.scrollToElement = /**
     * @param {?} selector
     * @param {?=} offset
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (selector, offset, duration, easeFunc) {
        if (offset === void 0) { offset = 0; }
        /** @type {?} */
        var target = this.view.querySelector(selector);
        return target ? this.scrollTo({ left: target.offsetLeft, top: target.offsetTop - offset, duration: duration, easeFunc: easeFunc }) : of();
    };
    /**
     * @param {?} left
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    SmoothScroll.prototype.scrollXTo = /**
     * @param {?} left
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (left, duration, easeFunc) {
        return this.scrollTo({ left: left, duration: duration, easeFunc: easeFunc });
    };
    /**
     * @param {?} top
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    SmoothScroll.prototype.scrollYTo = /**
     * @param {?} top
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (top, duration, easeFunc) {
        return this.scrollTo({ top: top, duration: duration, easeFunc: easeFunc });
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    SmoothScroll.prototype.scrollToTop = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.scrollYTo(0, duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    SmoothScroll.prototype.scrollToBottom = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.scrollYTo(this.view.scrollHeight - this.view.clientHeight, duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    SmoothScroll.prototype.scrollToRight = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.scrollXTo(this.view.scrollWidth, duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    SmoothScroll.prototype.scrollToLeft = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.scrollXTo(0, duration, easeFunc);
    };
    SmoothScroll.decorators = [
        { type: Directive, args: [{
                    selector: '[smoothScroll], [smooth-scroll]'
                },] }
    ];
    /** @nocollapse */
    SmoothScroll.ctorParameters = function () { return [
        { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] },
        { type: ElementRef }
    ]; };
    return SmoothScroll;
}());
/**
 * @param {?} options
 * @return {?}
 */
function smoothScroll(options) {
    return new Promise((/**
     * @param {?} resolve
     * @return {?}
     */
    function (resolve) {
        /** @type {?} */
        var currentTime = 0;
        /** @type {?} */
        var increment = 10;
        /** @type {?} */
        var valX = options.offsetLeft;
        /** @type {?} */
        var valY = options.offsetTop;
        /** @type {?} */
        var animateScroll = (/**
         * @return {?}
         */
        function () {
            // increment the time
            currentTime += increment;
            // find the value with the easing function
            if (typeof options.left !== 'undefined') {
                /** @type {?} */
                var deltaX = options.left - options.offsetLeft;
                valX = options.easeFunc(currentTime, options.offsetLeft, deltaX, options.duration);
            }
            if (typeof options.top !== 'undefined') {
                /** @type {?} */
                var deltaY = options.top - options.offsetTop;
                valY = options.easeFunc(currentTime, options.offsetTop, deltaY, options.duration);
            }
            // scroll to position
            options.scrollFunc(valX, valY);
            // do the animation unless its over
            if (currentTime < options.duration) {
                animationFrameScheduler.schedule(animateScroll);
            }
            else {
                resolve();
            }
        });
        animateScroll();
    }));
}
// easing functions http://goo.gl/5HLl8
/**
 * @param {?} t
 * @param {?} b
 * @param {?} c
 * @param {?} d
 * @return {?}
 */
function easeInOutQuad(t, b, c, d) {
    t /= d / 2;
    if (t < 1) {
        return (c / 2) * t * t + b;
    }
    t--;
    return (-c / 2) * (t * (t - 2) - 1) + b;
}
/**
 * @param {?} t
 * @param {?} b
 * @param {?} c
 * @param {?} d
 * @return {?}
 */
function easeInCubic(t, b, c, d) {
    /** @type {?} */
    var tc = (t /= d) * t * t;
    return b + c * tc;
}
/**
 * @param {?} t
 * @param {?} b
 * @param {?} c
 * @param {?} d
 * @return {?}
 */
function inOutQuintic(t, b, c, d) {
    /** @type {?} */
    var ts = (t /= d) * t;
    /** @type {?} */
    var tc = ts * t;
    return b + c * (6 * tc * ts + -15 * ts * ts + 10 * tc);
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var SmoothScrollModule = /** @class */ (function () {
    function SmoothScrollModule() {
    }
    SmoothScrollModule.decorators = [
        { type: NgModule, args: [{
                    imports: [ScrollingModule],
                    declarations: [SmoothScroll],
                    exports: [SmoothScroll]
                },] }
    ];
    return SmoothScrollModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgScrollbarView = /** @class */ (function () {
    function NgScrollbarView(virtualScrollViewport, smoothScroll) {
        this.virtualScrollViewport = virtualScrollViewport;
        this.smoothScroll = smoothScroll;
        if (!virtualScrollViewport) {
            throw new Error('NgScrollBar: add [NgScrollbarView] directive on CdkVirtualScrollViewport component only');
        }
        if (!smoothScroll) {
            throw new Error('NgScrollBar: add [smoothScroll] directive is required with [NgScrollbarView]');
        }
    }
    NgScrollbarView.decorators = [
        { type: Directive, args: [{
                    selector: '[ngScrollbarView]'
                },] }
    ];
    /** @nocollapse */
    NgScrollbarView.ctorParameters = function () { return [
        { type: CdkVirtualScrollViewport, decorators: [{ type: Optional }] },
        { type: SmoothScroll, decorators: [{ type: Optional }] }
    ]; };
    return NgScrollbarView;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
// Native scrollbar size is 17px on all browsers,
// This value will be used to push the native scrollbar out of the scroll view to hide them
// An extra 1px is added to hide them properly on Edge browser
/** @type {?} */
var NATIVE_SCROLLBAR_SIZE = '18px';
var NgScrollbar = /** @class */ (function () {
    function NgScrollbar(_changeDetectorRef, _breakpointObserver, _platform) {
        this._changeDetectorRef = _changeDetectorRef;
        this._breakpointObserver = _breakpointObserver;
        this._platform = _platform;
        /**
         * Horizontal custom scrollbar
         */
        this.trackX = false;
        /**
         * Vertical custom Scrollbar
         */
        this.trackY = true;
        /**
         * Scrollbar visibility
         */
        this.shown = 'native';
        /**
         * Auto update scrollbars on content changes (Mutation Observer)
         */
        this.autoUpdate = true;
        /**
         * The smooth scroll duration when a scrollbar is clicked
         */
        this.scrollToDuration = 300;
        /**
         * Disable custom scrollbars on specific breakpoints
         */
        this.disableOnBreakpoints = [
            Breakpoints.HandsetLandscape,
            Breakpoints.HandsetPortrait
        ];
        this._disabled = false;
        /**
         * Unsubscribe component observables on destroy
         */
        this._unsubscribe$ = new Subject();
        /**
         * Steam that emits when scrollbar thumbnail needs to update (for internal uses)
         */
        this._updateObserver = new Subject();
        this.updateObserver = this._updateObserver.asObservable();
    }
    Object.defineProperty(NgScrollbar.prototype, "disabled", {
        /** Disable custom scrollbars and switch back to native scrollbars */
        get: /**
         * Disable custom scrollbars and switch back to native scrollbars
         * @return {?}
         */
        function () {
            return this._disabled;
        },
        set: /**
         * @param {?} disable
         * @return {?}
         */
        function (disable) {
            disable ? this.disable() : this.enable();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgScrollbar.prototype, "view", {
        /** Viewport Element */
        get: /**
         * Viewport Element
         * @return {?}
         */
        function () {
            return this.customViewPort
                ? this.customViewPort.virtualScrollViewport.getElementRef().nativeElement
                : this.scrollViewport.getElementRef().nativeElement;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgScrollbar.prototype, "scrollable", {
        get: /**
         * @return {?}
         */
        function () {
            return this.customViewPort
                ? this.customViewPort.virtualScrollViewport
                : this.scrollViewport;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgScrollbar.prototype, "smoothScroll", {
        get: /**
         * @return {?}
         */
        function () {
            return this.customViewPort
                ? this.customViewPort.smoothScroll
                : this.viewSmoothScroll;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgScrollbar.prototype, "hideNativeScrollbars", {
        get: /**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var size = this.disabled ? '100%' : "calc(100% + " + NATIVE_SCROLLBAR_SIZE + ")";
            return {
                width: this.trackY ? size : '100%',
                height: this.trackX ? size : '100%'
            };
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    NgScrollbar.prototype.showScrollbarY = /**
     * @return {?}
     */
    function () {
        return this.shown === 'always' || this.view.scrollHeight > this.view.clientHeight;
    };
    /**
     * @return {?}
     */
    NgScrollbar.prototype.showScrollbarX = /**
     * @return {?}
     */
    function () {
        return this.shown === 'always' || this.view.scrollWidth > this.view.clientWidth;
    };
    /**
     * @return {?}
     */
    NgScrollbar.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Avoid 'expression has changed after it was checked' error when 'disableOnBreakpoints' is set to false
        Promise.resolve().then((/**
         * @return {?}
         */
        function () {
            if (!_this.disabled) {
                if (_this.disableOnBreakpoints) {
                    // Enable/Disable custom scrollbar on breakpoints (Used to disable scrollbars on mobile phones)
                    _this._breakpointObserver.observe(_this.disableOnBreakpoints).pipe(tap((/**
                     * @param {?} result
                     * @return {?}
                     */
                    function (result) { return result.matches ? _this.disable() : _this.enable(); })), takeUntil(_this._unsubscribe$)).subscribe();
                }
                else {
                    _this.enable();
                }
            }
            // Update state on content changes
            _this.updateObserver.pipe(throttleTime(200), tap((/**
             * @return {?}
             */
            function () { return _this._changeDetectorRef.markForCheck(); })), takeUntil(_this._unsubscribe$)).subscribe();
            if (isPlatformBrowser(_this._platform)) {
                // Update on window resize
                fromEvent(window, 'resize').pipe(throttleTime(200), tap((/**
                 * @return {?}
                 */
                function () { return _this.update(); })), takeUntil(_this._unsubscribe$)).subscribe();
            }
        }));
    };
    /**
     * @return {?}
     */
    NgScrollbar.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this._unsubscribe$.next();
        this._unsubscribe$.complete();
        if (this._observer) {
            this._observer.disconnect();
        }
    };
    /**
     * Update scrollbar thumbnail position
     */
    /**
     * Update scrollbar thumbnail position
     * @return {?}
     */
    NgScrollbar.prototype.update = /**
     * Update scrollbar thumbnail position
     * @return {?}
     */
    function () {
        if (!this.disabled) {
            this._updateObserver.next();
        }
    };
    /**
     * Enable custom scrollbar
     */
    /**
     * Enable custom scrollbar
     * @return {?}
     */
    NgScrollbar.prototype.enable = /**
     * Enable custom scrollbar
     * @return {?}
     */
    function () {
        var _this = this;
        if (this.view) {
            this._disabled = false;
            // Update view
            this._changeDetectorRef.markForCheck();
            if (!this.customViewPort && this.autoUpdate && isPlatformBrowser(this._platform)) {
                // Observe content changes
                this._observer = new MutationObserver((/**
                 * @return {?}
                 */
                function () { return _this.update(); }));
                this._observer.observe(this.view, { subtree: true, childList: true, characterData: true });
            }
        }
    };
    /**
     * Disable custom scrollbar
     */
    /**
     * Disable custom scrollbar
     * @return {?}
     */
    NgScrollbar.prototype.disable = /**
     * Disable custom scrollbar
     * @return {?}
     */
    function () {
        this._disabled = true;
        if (this._observer) {
            this._observer.disconnect();
        }
    };
    /**
     * @param {?} options
     * @return {?}
     */
    NgScrollbar.prototype.scrollTo = /**
     * @param {?} options
     * @return {?}
     */
    function (options) {
        return this.smoothScroll.scrollTo(options);
    };
    /**
     * @param {?} selector
     * @param {?=} offset
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToElement = /**
     * @param {?} selector
     * @param {?=} offset
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (selector, offset, duration, easeFunc) {
        if (offset === void 0) { offset = 0; }
        return this.smoothScroll.scrollToElement(selector, offset, duration, easeFunc);
    };
    /**
     * @param {?} to
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollXTo = /**
     * @param {?} to
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (to, duration, easeFunc) {
        return this.smoothScroll.scrollXTo(to, duration, easeFunc);
    };
    /**
     * @param {?} to
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollYTo = /**
     * @param {?} to
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (to, duration, easeFunc) {
        return this.smoothScroll.scrollYTo(to, duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToTop = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.smoothScroll.scrollToTop(duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToBottom = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.smoothScroll.scrollToBottom(duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToRight = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.smoothScroll.scrollToRight(duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToLeft = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.smoothScroll.scrollToLeft(duration, easeFunc);
    };
    NgScrollbar.decorators = [
        { type: Component, args: [{
                    selector: 'ng-scrollbar',
                    template: "<div class=\"ng-scrollbar-layout ng-scrollbar-x-layout\"\r\n     [class.ng-scrollbar-invert]=\"invertX\">\r\n\r\n  <div class=\"ng-scrollbar-layout ng-scrollbar-y-layout\"\r\n       [class.ng-scrollbar-invert]=\"invertY\">\r\n\r\n    <div class=\"ng-scroll-view-container\">\r\n      <div #view\r\n           cdkScrollable\r\n           smoothScroll\r\n           class=\"ng-scroll-view {{viewClass}}\"\r\n           [ngStyle]=\"hideNativeScrollbars\">\r\n        <ng-content></ng-content>\r\n      </div>\r\n    </div>\r\n\r\n    <ng-scrollbar-y #y\r\n                    *ngIf=\"!disabled && trackY\"\r\n                    [class.ng-scrollbar-visible]=\"showScrollbarY()\"\r\n                    [barClass]=\"barClass\"\r\n                    [thumbClass]=\"thumbClass\"\r\n                    [scrollToDuration]=\"scrollToDuration\">\r\n    </ng-scrollbar-y>\r\n  </div>\r\n\r\n  <ng-scrollbar-x #x\r\n                  *ngIf=\"!disabled && trackX\"\r\n                  [class.ng-scrollbar-visible]=\"showScrollbarX()\"\r\n                  [barClass]=\"barClass\"\r\n                  [thumbClass]=\"thumbClass\"\r\n                  [scrollToDuration]=\"scrollToDuration\">\r\n  </ng-scrollbar-x>\r\n\r\n</div>\r\n",
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    host: {
                        '[attr.customView]': '!!customViewPort',
                        '[attr.trackX]': 'trackX',
                        '[attr.trackY]': 'trackY',
                        '[attr.compact]': 'compact',
                        '[attr.autoHide]': 'shown === "hover"'
                    },
                    styles: [":host{display:block;overflow:hidden;--scrollbar-color:transparent;--scrollbar-container-color:transparent;--scrollbar-thumb-color:rgba(0, 0, 0, 0.2);--scrollbar-thumb-hover-color:rgba(0, 0, 0, 0.3);--scrollbar-border-radius:4px;--scrollbar-size:6px;--scrollbar-padding:8px;--scroll-view-margin:0;--scroll-view-color:transparent}:host[trackY=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>.ng-scroll-view{overflow-y:scroll}:host[trackX=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>.ng-scroll-view{overflow-x:scroll}:host>.ng-scrollbar-x-layout{flex-direction:column}:host>.ng-scrollbar-x-layout.ng-scrollbar-invert{flex-direction:column-reverse}:host>.ng-scrollbar-x-layout>.ng-scrollbar-y-layout{flex-direction:row}:host>.ng-scrollbar-x-layout>.ng-scrollbar-y-layout.ng-scrollbar-invert{flex-direction:row-reverse}:host[compact=true]>.ng-scrollbar-x-layout>ng-scrollbar-x{position:absolute;bottom:0}:host[compact=true]>.ng-scrollbar-x-layout.ng-scrollbar-invert>ng-scrollbar-x{top:0;bottom:unset}:host[compact=true]>.ng-scrollbar-x-layout>.ng-scrollbar-y-layout>ng-scrollbar-y{position:absolute;right:0;left:unset}:host[compact=true]>.ng-scrollbar-x-layout>.ng-scrollbar-y-layout.ng-scrollbar-invert>ng-scrollbar-y{right:unset;left:0}:host[autoHide=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>ng-scrollbar-y,:host[autoHide=true]>.ng-scrollbar-layout>ng-scrollbar-x{opacity:0;transition:opacity 120ms ease-out}:host[autoHide=true]:active>.ng-scrollbar-layout>.ng-scrollbar-layout>ng-scrollbar-y,:host[autoHide=true]:active>.ng-scrollbar-layout>ng-scrollbar-x,:host[autoHide=true]:focus>.ng-scrollbar-layout>.ng-scrollbar-layout>ng-scrollbar-y,:host[autoHide=true]:focus>.ng-scrollbar-layout>ng-scrollbar-x,:host[autoHide=true]:hover>.ng-scrollbar-layout>.ng-scrollbar-layout>ng-scrollbar-y,:host[autoHide=true]:hover>.ng-scrollbar-layout>ng-scrollbar-x{opacity:1;transition:opacity 340ms ease-out}.ng-scroll-view,.ng-scrollbar-layout,:host{position:relative;height:100%;width:100%}.ng-scrollbar-layout{display:flex;min-height:0}.ng-scroll-view-container{flex:1;position:relative;overflow:hidden;margin:var(--scroll-view-margin)}.ng-scroll-view{box-sizing:content-box;-webkit-transform:translateZ(0);transform:translateZ(0);background:var(--scroll-view-color);-webkit-overflow-scrolling:touch}ng-scrollbar-x,ng-scrollbar-y{display:none;box-sizing:border-box;padding:var(--scrollbar-padding);background:var(--scrollbar-container-color)}ng-scrollbar-x.ng-scrollbar-visible,ng-scrollbar-y.ng-scrollbar-visible{display:block}ng-scrollbar-y{top:0;bottom:0}ng-scrollbar-x{left:0;right:0}::ng-deep ng-scrollbar-y .ng-scrollbar{width:var(--scrollbar-size)}::ng-deep ng-scrollbar-y .ng-scrollbar-thumb{width:100%}::ng-deep ng-scrollbar-x .ng-scrollbar{height:var(--scrollbar-size)}::ng-deep ng-scrollbar-x .ng-scrollbar-thumb{height:100%}::ng-deep .ng-scrollbar{height:100%;width:100%;z-index:1;border-radius:var(--scrollbar-border-radius);background-color:var(--scrollbar-color)}::ng-deep .ng-scrollbar-thumb{box-sizing:border-box;position:relative;width:0;height:0;border-radius:inherit;background-color:var(--scrollbar-thumb-color);-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0);transition:height 150ms ease-out}::ng-deep .ng-scrollbar-thumb:active,::ng-deep .ng-scrollbar-thumb:hover{background-color:var(--scrollbar-thumb-hover-color)}::ng-deep cdk-virtual-scroll-viewport{height:100%}::ng-deep ng-scrollbar[customView=true] .ng-scroll-view{overflow:hidden!important}::ng-deep ng-scrollbar[trackY=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>.ng-scroll-view,::ng-deep ng-scrollbar[trackY=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>cdk-virtual-scroll-viewport{overflow-y:scroll}::ng-deep ng-scrollbar[trackX=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>.ng-scroll-view,::ng-deep ng-scrollbar[trackX=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>cdk-virtual-scroll-viewport{overflow-x:scroll}"]
                }] }
    ];
    /** @nocollapse */
    NgScrollbar.ctorParameters = function () { return [
        { type: ChangeDetectorRef },
        { type: BreakpointObserver },
        { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] }
    ]; };
    NgScrollbar.propDecorators = {
        trackX: [{ type: Input }],
        trackY: [{ type: Input }],
        shown: [{ type: Input }],
        autoUpdate: [{ type: Input }],
        viewClass: [{ type: Input }],
        barClass: [{ type: Input }],
        thumbClass: [{ type: Input }],
        scrollToDuration: [{ type: Input }],
        compact: [{ type: Input }],
        invertY: [{ type: Input }],
        invertX: [{ type: Input }],
        disableOnBreakpoints: [{ type: Input }],
        disabled: [{ type: Input, args: ['disabled',] }],
        verticalScrollbar: [{ type: ViewChild, args: ['y', { read: ElementRef },] }],
        horizontalScrollbar: [{ type: ViewChild, args: ['x', { read: ElementRef },] }],
        scrollViewport: [{ type: ViewChild, args: [CdkScrollable,] }],
        viewSmoothScroll: [{ type: ViewChild, args: [SmoothScroll,] }],
        customViewPort: [{ type: ContentChild, args: [NgScrollbarView,] }]
    };
    return NgScrollbar;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgScrollbarThumb = /** @class */ (function () {
    function NgScrollbarThumb(_parent, _platform, _zone) {
        this._parent = _parent;
        this._platform = _platform;
        this._zone = _zone;
        this._minThumbSize = 20;
        this._naturalThumbSize = 0;
        this._thumbSize = 0;
        this._trackMax = 0;
        this._scrollMax = 0;
        this._currPos = 0;
        this._scroll$ = Subscription.EMPTY;
        this._thumbDrag$ = Subscription.EMPTY;
        this._updateObserver$ = Subscription.EMPTY;
        this._state = new BehaviorSubject({
            transform: 'translate3d(0, 0, 0)'
        });
        /**
         * Scrollbar styles
         */
        this.scrollbarStyle = this._state.asObservable();
    }
    Object.defineProperty(NgScrollbarThumb.prototype, "thumbSize", {
        get: /**
         * @return {?}
         */
        function () {
            return 0;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    NgScrollbarThumb.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Avoid SSR Error
        if (isPlatformBrowser(this._platform)) {
            this._view = this._parent.view;
            // Start view scroll event
            this._scroll$ = this._parent.scrollable.elementScrolled()
                .subscribe((/**
             * @return {?}
             */
            function () { return _this.updateScrollbar(); }));
            // Start scrollbar thumbnail drag events
            this._zone.runOutsideAngular((/**
             * @return {?}
             */
            function () {
                return _this._thumbDrag$ = _this.startThumbEvents().subscribe();
            }));
            // Update scrollbar thumbnail size on content changes
            this._updateObserver$ = this._parent.updateObserver.pipe(throttleTime(200), tap((/**
             * @return {?}
             */
            function () { return _this.updateScrollbar(); })), 
            // Make sure scrollbar thumbnail position is correct after the new content is rendered
            debounceTime(200), tap((/**
             * @return {?}
             */
            function () { return _this.updateScrollbar(); }))).subscribe();
            // Initialize scrollbar
            setTimeout((/**
             * @return {?}
             */
            function () { return _this.updateScrollbar(); }), 200);
        }
    };
    /**
     * @return {?}
     */
    NgScrollbarThumb.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this._scroll$.unsubscribe();
        this._thumbDrag$.unsubscribe();
        this._updateObserver$.unsubscribe();
    };
    /**
     * Scrollbar click
     * @param e Mouse event
     */
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    NgScrollbarThumb.prototype.onScrollbarHolderClick = /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    function (e) {
    };
    /**
     * Update scrollbar
     */
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    NgScrollbarThumb.prototype.updateScrollbar = /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    function () {
    };
    /**
     * Start vertical thumb worker
     */
    /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    NgScrollbarThumb.prototype.startThumbEvents = /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    function () {
        return undefined;
    };
    /**
     * Get scrollbar thumb size
     * @param naturalThumbSize
     * @param scrollMax
     */
    /**
     * Get scrollbar thumb size
     * @protected
     * @param {?} naturalThumbSize
     * @param {?} scrollMax
     * @return {?}
     */
    NgScrollbarThumb.prototype.scrollBoundaries = /**
     * Get scrollbar thumb size
     * @protected
     * @param {?} naturalThumbSize
     * @param {?} scrollMax
     * @return {?}
     */
    function (naturalThumbSize, scrollMax) {
        return (naturalThumbSize < this._minThumbSize) ? this._minThumbSize : scrollMax ? naturalThumbSize : 0;
    };
    /**
     * @protected
     * @param {?} state
     * @return {?}
     */
    NgScrollbarThumb.prototype.updateState = /**
     * @protected
     * @param {?} state
     * @return {?}
     */
    function (state) {
        this._state.next(__assign({}, this._state.value, state));
    };
    NgScrollbarThumb.propDecorators = {
        barClass: [{ type: Input }],
        thumbClass: [{ type: Input }],
        scrollToDuration: [{ type: Input }],
        bar: [{ type: ViewChild, args: ['bar',] }],
        thumb: [{ type: ViewChild, args: ['thumb',] }]
    };
    return NgScrollbarThumb;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgScrollbarY = /** @class */ (function (_super) {
    __extends(NgScrollbarY, _super);
    function NgScrollbarY(_document, _parent, _platform, _zone) {
        var _this = _super.call(this, _parent, _platform, _zone) || this;
        _this._document = _document;
        _this._parent = _parent;
        _this._zone = _zone;
        return _this;
    }
    Object.defineProperty(NgScrollbarY.prototype, "thumbSize", {
        /**
         * Calculate scrollbar thumbnail size
         */
        get: /**
         * Calculate scrollbar thumbnail size
         * @return {?}
         */
        function () {
            /** @type {?} */
            var barClientHeight = this.bar.nativeElement.clientHeight;
            /** @type {?} */
            var viewClientHeight = this._view.clientHeight;
            /** @type {?} */
            var viewScrollHeight = this._view.scrollHeight;
            this._naturalThumbSize = barClientHeight / viewScrollHeight * barClientHeight;
            this._scrollMax = viewScrollHeight - viewClientHeight;
            return this.scrollBoundaries(this._naturalThumbSize, this._scrollMax);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Scrollbar click
     * @param e Mouse event
     */
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    NgScrollbarY.prototype.onScrollbarHolderClick = /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    function (e) {
        if (e.target === e.currentTarget) {
            /** @type {?} */
            var offsetY = e.offsetY - this._naturalThumbSize * .5;
            /** @type {?} */
            var thumbPositionPercentage = offsetY * 100 / this.bar.nativeElement.clientHeight;
            /** @type {?} */
            var value = thumbPositionPercentage * this._view.scrollHeight / 100;
            this._parent.scrollTo((/** @type {?} */ ({ top: value, duration: this.scrollToDuration }))).subscribe();
        }
    };
    /**
     * Update scrollbar
     */
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    NgScrollbarY.prototype.updateScrollbar = /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    function () {
        var _this = this;
        this._thumbSize = this.thumb.nativeElement.clientHeight;
        this._trackMax = this.bar.nativeElement.clientHeight - this._thumbSize;
        this._currPos = this._view.scrollTop * this._trackMax / this._scrollMax;
        this._zone.run((/**
         * @return {?}
         */
        function () {
            animationFrameScheduler.schedule((/**
             * @return {?}
             */
            function () {
                return _this.updateState({
                    transform: "translate3d(0, " + _this._currPos + "px, 0)",
                    height: _this.thumbSize + "px"
                });
            }));
        }));
    };
    /**
     * Start vertical thumb worker
     */
    /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    NgScrollbarY.prototype.startThumbEvents = /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var mouseDown$ = fromEvent(this.thumb.nativeElement, 'mousedown');
        /** @type {?} */
        var mouseMove$ = fromEvent(this._document, 'mousemove');
        /** @type {?} */
        var mouseUp$ = fromEvent(this._document, 'mouseup').pipe(tap((/**
         * @return {?}
         */
        function () { return _this._document.onselectstart = null; })));
        return mouseDown$.pipe(tap((/**
         * @return {?}
         */
        function () {
            _this._document.onselectstart = (/**
             * @return {?}
             */
            function () { return false; });
            // Initialize trackMax for before start dragging
            _this._trackMax = _this.bar.nativeElement.clientHeight - _this._thumbSize;
        })), pluck('offsetY'), mergeMap((/**
         * @param {?} mouseDownOffset
         * @return {?}
         */
        function (mouseDownOffset) { return mouseMove$.pipe(takeUntil(mouseUp$), pluck('clientY'), tap((/**
         * @param {?} mouseMoveClient
         * @return {?}
         */
        function (mouseMoveClient) {
            /** @type {?} */
            var offsetY = mouseMoveClient - _this.bar.nativeElement.getBoundingClientRect().top;
            /** @type {?} */
            var value = _this._scrollMax * (offsetY - mouseDownOffset) / _this._trackMax;
            _this._parent.scrollable.scrollTo({ top: value });
        }))); })));
    };
    NgScrollbarY.decorators = [
        { type: Component, args: [{
                    selector: 'ng-scrollbar-y',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: "\n    <div #bar class=\"ng-scrollbar {{barClass}}\" (mousedown)=\"onScrollbarHolderClick($event)\">\n      <div #thumb class=\"ng-scrollbar-thumb {{thumbClass}}\" [ngStyle]=\"scrollbarStyle | async\"></div>\n    </div>\n  "
                }] }
    ];
    /** @nocollapse */
    NgScrollbarY.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: NgScrollbar, decorators: [{ type: Inject, args: [forwardRef((/**
                         * @return {?}
                         */
                        function () { return NgScrollbar; })),] }] },
        { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] },
        { type: NgZone }
    ]; };
    return NgScrollbarY;
}(NgScrollbarThumb));

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgScrollbarX = /** @class */ (function (_super) {
    __extends(NgScrollbarX, _super);
    function NgScrollbarX(_document, _parent, _platform, _dir, _zone) {
        var _this = _super.call(this, _parent, _platform, _zone) || this;
        _this._document = _document;
        _this._parent = _parent;
        _this._dir = _dir;
        _this._zone = _zone;
        return _this;
    }
    Object.defineProperty(NgScrollbarX.prototype, "thumbSize", {
        /**
         * Calculate scrollbar thumbnail size
         */
        get: /**
         * Calculate scrollbar thumbnail size
         * @return {?}
         */
        function () {
            /** @type {?} */
            var barClientWidth = this.bar.nativeElement.clientWidth;
            /** @type {?} */
            var viewClientWidth = this._view.clientWidth;
            /** @type {?} */
            var viewScrollWidth = this._view.scrollWidth;
            this._naturalThumbSize = barClientWidth / viewScrollWidth * barClientWidth;
            this._scrollMax = viewScrollWidth - viewClientWidth;
            return this.scrollBoundaries(this._naturalThumbSize, this._scrollMax);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Scrollbar click
     * @param e Mouse event
     */
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    NgScrollbarX.prototype.onScrollbarHolderClick = /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    function (e) {
        if (e.target === e.currentTarget) {
            /** @type {?} */
            var offsetX = e.offsetX - this._naturalThumbSize * .5;
            /** @type {?} */
            var thumbPositionPercentage = offsetX * 100 / this.bar.nativeElement.clientWidth;
            /** @type {?} */
            var value = thumbPositionPercentage * this._view.scrollWidth / 100;
            this._parent.scrollTo((/** @type {?} */ ({ left: value, duration: this.scrollToDuration }))).subscribe();
        }
    };
    /**
     * Update scrollbar
     */
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    NgScrollbarX.prototype.updateScrollbar = /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    function () {
        var _this = this;
        this._thumbSize = this.thumb.nativeElement.clientWidth;
        this._trackMax = this.bar.nativeElement.clientWidth - this._thumbSize;
        this._currPos = this._view.scrollLeft * this._trackMax / this._scrollMax;
        this._zone.run((/**
         * @return {?}
         */
        function () {
            animationFrameScheduler.schedule((/**
             * @return {?}
             */
            function () {
                return _this.updateState({
                    transform: "translate3d(" + (_this._dir.value === 'rtl' ? _this._currPos - _this._trackMax : _this._currPos) + "px, 0, 0)",
                    width: _this.thumbSize + "px"
                });
            }));
        }));
    };
    /**
     * Start horizontal thumb worker
     */
    /**
     * Start horizontal thumb worker
     * @protected
     * @return {?}
     */
    NgScrollbarX.prototype.startThumbEvents = /**
     * Start horizontal thumb worker
     * @protected
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var mouseDown$ = fromEvent(this.thumb.nativeElement, 'mousedown');
        /** @type {?} */
        var mouseMove$ = fromEvent(this._document, 'mousemove');
        /** @type {?} */
        var mouseUp$ = fromEvent(this._document, 'mouseup').pipe(tap((/**
         * @return {?}
         */
        function () { return _this._document.onselectstart = null; })));
        return mouseDown$.pipe(tap((/**
         * @return {?}
         */
        function () {
            _this._document.onselectstart = (/**
             * @return {?}
             */
            function () { return false; });
            // Initialize trackMax for before start dragging
            _this._trackMax = _this.bar.nativeElement.clientWidth - _this._thumbSize;
        })), pluck('offsetX'), mergeMap((/**
         * @param {?} mouseDownOffset
         * @return {?}
         */
        function (mouseDownOffset) { return mouseMove$.pipe(takeUntil(mouseUp$), pluck('clientX'), tap((/**
         * @param {?} mouseMoveClient
         * @return {?}
         */
        function (mouseMoveClient) {
            /** @type {?} */
            var offsetX = mouseMoveClient - _this.bar.nativeElement.getBoundingClientRect().left;
            /** @type {?} */
            var value = _this._scrollMax * (offsetX - mouseDownOffset) / _this._trackMax;
            if (_this._dir.value === 'rtl') {
                value = value === 0 ? offsetX - _this._trackMax : value;
            }
            _this._parent.scrollable.scrollTo({ left: value });
        }))); })));
    };
    NgScrollbarX.decorators = [
        { type: Component, args: [{
                    selector: 'ng-scrollbar-x',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: "\n    <div #bar class=\"ng-scrollbar {{barClass}}\" (mousedown)=\"onScrollbarHolderClick($event)\">\n      <div #thumb class=\"ng-scrollbar-thumb {{thumbClass}}\" [ngStyle]=\"scrollbarStyle | async\"></div>\n    </div>\n  "
                }] }
    ];
    /** @nocollapse */
    NgScrollbarX.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: NgScrollbar, decorators: [{ type: Inject, args: [forwardRef((/**
                         * @return {?}
                         */
                        function () { return NgScrollbar; })),] }] },
        { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] },
        { type: Directionality },
        { type: NgZone }
    ]; };
    return NgScrollbarX;
}(NgScrollbarThumb));

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NgScrollbarModule = /** @class */ (function () {
    function NgScrollbarModule() {
    }
    NgScrollbarModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        CommonModule,
                        ScrollingModule,
                        LayoutModule,
                        BidiModule,
                        SmoothScrollModule
                    ],
                    declarations: [
                        NgScrollbar,
                        NgScrollbarY,
                        NgScrollbarX,
                        NgScrollbarView
                    ],
                    exports: [
                        NgScrollbar,
                        NgScrollbarView,
                        SmoothScrollModule
                    ]
                },] }
    ];
    return NgScrollbarModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

export { NgScrollbar, NgScrollbarModule, SmoothScroll, SmoothScrollModule, easeInCubic, easeInOutQuad, inOutQuintic, smoothScroll, NgScrollbarView as ɵa, NgScrollbarY as ɵb, NgScrollbarThumb as ɵc, NgScrollbarX as ɵd };
//# sourceMappingURL=ngx-scrollbar.js.map
