/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Inject, Input, ViewChild, ContentChild, ElementRef, ChangeDetectorRef, ChangeDetectionStrategy, PLATFORM_ID } from '@angular/core';
import { isPlatformBrowser } from '@angular/common';
import { CdkScrollable } from '@angular/cdk/scrolling';
import { BreakpointObserver, Breakpoints } from '@angular/cdk/layout';
import { fromEvent, Subject } from 'rxjs';
import { takeUntil, tap, throttleTime } from 'rxjs/operators';
import { SmoothScroll } from '../smooth-scroll/smooth-scroll';
import { NgScrollbarView } from './ng-scrollbar-view';
// Native scrollbar size is 17px on all browsers,
// This value will be used to push the native scrollbar out of the scroll view to hide them
// An extra 1px is added to hide them properly on Edge browser
/** @type {?} */
var NATIVE_SCROLLBAR_SIZE = '18px';
var NgScrollbar = /** @class */ (function () {
    function NgScrollbar(_changeDetectorRef, _breakpointObserver, _platform) {
        this._changeDetectorRef = _changeDetectorRef;
        this._breakpointObserver = _breakpointObserver;
        this._platform = _platform;
        /**
         * Horizontal custom scrollbar
         */
        this.trackX = false;
        /**
         * Vertical custom Scrollbar
         */
        this.trackY = true;
        /**
         * Scrollbar visibility
         */
        this.shown = 'native';
        /**
         * Auto update scrollbars on content changes (Mutation Observer)
         */
        this.autoUpdate = true;
        /**
         * The smooth scroll duration when a scrollbar is clicked
         */
        this.scrollToDuration = 300;
        /**
         * Disable custom scrollbars on specific breakpoints
         */
        this.disableOnBreakpoints = [
            Breakpoints.HandsetLandscape,
            Breakpoints.HandsetPortrait
        ];
        this._disabled = false;
        /**
         * Unsubscribe component observables on destroy
         */
        this._unsubscribe$ = new Subject();
        /**
         * Steam that emits when scrollbar thumbnail needs to update (for internal uses)
         */
        this._updateObserver = new Subject();
        this.updateObserver = this._updateObserver.asObservable();
    }
    Object.defineProperty(NgScrollbar.prototype, "disabled", {
        /** Disable custom scrollbars and switch back to native scrollbars */
        get: /**
         * Disable custom scrollbars and switch back to native scrollbars
         * @return {?}
         */
        function () {
            return this._disabled;
        },
        set: /**
         * @param {?} disable
         * @return {?}
         */
        function (disable) {
            disable ? this.disable() : this.enable();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgScrollbar.prototype, "view", {
        /** Viewport Element */
        get: /**
         * Viewport Element
         * @return {?}
         */
        function () {
            return this.customViewPort
                ? this.customViewPort.virtualScrollViewport.getElementRef().nativeElement
                : this.scrollViewport.getElementRef().nativeElement;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgScrollbar.prototype, "scrollable", {
        get: /**
         * @return {?}
         */
        function () {
            return this.customViewPort
                ? this.customViewPort.virtualScrollViewport
                : this.scrollViewport;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgScrollbar.prototype, "smoothScroll", {
        get: /**
         * @return {?}
         */
        function () {
            return this.customViewPort
                ? this.customViewPort.smoothScroll
                : this.viewSmoothScroll;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgScrollbar.prototype, "hideNativeScrollbars", {
        get: /**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var size = this.disabled ? '100%' : "calc(100% + " + NATIVE_SCROLLBAR_SIZE + ")";
            return {
                width: this.trackY ? size : '100%',
                height: this.trackX ? size : '100%'
            };
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    NgScrollbar.prototype.showScrollbarY = /**
     * @return {?}
     */
    function () {
        return this.shown === 'always' || this.view.scrollHeight > this.view.clientHeight;
    };
    /**
     * @return {?}
     */
    NgScrollbar.prototype.showScrollbarX = /**
     * @return {?}
     */
    function () {
        return this.shown === 'always' || this.view.scrollWidth > this.view.clientWidth;
    };
    /**
     * @return {?}
     */
    NgScrollbar.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Avoid 'expression has changed after it was checked' error when 'disableOnBreakpoints' is set to false
        Promise.resolve().then((/**
         * @return {?}
         */
        function () {
            if (!_this.disabled) {
                if (_this.disableOnBreakpoints) {
                    // Enable/Disable custom scrollbar on breakpoints (Used to disable scrollbars on mobile phones)
                    _this._breakpointObserver.observe(_this.disableOnBreakpoints).pipe(tap((/**
                     * @param {?} result
                     * @return {?}
                     */
                    function (result) { return result.matches ? _this.disable() : _this.enable(); })), takeUntil(_this._unsubscribe$)).subscribe();
                }
                else {
                    _this.enable();
                }
            }
            // Update state on content changes
            _this.updateObserver.pipe(throttleTime(200), tap((/**
             * @return {?}
             */
            function () { return _this._changeDetectorRef.markForCheck(); })), takeUntil(_this._unsubscribe$)).subscribe();
            if (isPlatformBrowser(_this._platform)) {
                // Update on window resize
                fromEvent(window, 'resize').pipe(throttleTime(200), tap((/**
                 * @return {?}
                 */
                function () { return _this.update(); })), takeUntil(_this._unsubscribe$)).subscribe();
            }
        }));
    };
    /**
     * @return {?}
     */
    NgScrollbar.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this._unsubscribe$.next();
        this._unsubscribe$.complete();
        if (this._observer) {
            this._observer.disconnect();
        }
    };
    /**
     * Update scrollbar thumbnail position
     */
    /**
     * Update scrollbar thumbnail position
     * @return {?}
     */
    NgScrollbar.prototype.update = /**
     * Update scrollbar thumbnail position
     * @return {?}
     */
    function () {
        if (!this.disabled) {
            this._updateObserver.next();
        }
    };
    /**
     * Enable custom scrollbar
     */
    /**
     * Enable custom scrollbar
     * @return {?}
     */
    NgScrollbar.prototype.enable = /**
     * Enable custom scrollbar
     * @return {?}
     */
    function () {
        var _this = this;
        if (this.view) {
            this._disabled = false;
            // Update view
            this._changeDetectorRef.markForCheck();
            if (!this.customViewPort && this.autoUpdate && isPlatformBrowser(this._platform)) {
                // Observe content changes
                this._observer = new MutationObserver((/**
                 * @return {?}
                 */
                function () { return _this.update(); }));
                this._observer.observe(this.view, { subtree: true, childList: true, characterData: true });
            }
        }
    };
    /**
     * Disable custom scrollbar
     */
    /**
     * Disable custom scrollbar
     * @return {?}
     */
    NgScrollbar.prototype.disable = /**
     * Disable custom scrollbar
     * @return {?}
     */
    function () {
        this._disabled = true;
        if (this._observer) {
            this._observer.disconnect();
        }
    };
    /**
     * @param {?} options
     * @return {?}
     */
    NgScrollbar.prototype.scrollTo = /**
     * @param {?} options
     * @return {?}
     */
    function (options) {
        return this.smoothScroll.scrollTo(options);
    };
    /**
     * @param {?} selector
     * @param {?=} offset
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToElement = /**
     * @param {?} selector
     * @param {?=} offset
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (selector, offset, duration, easeFunc) {
        if (offset === void 0) { offset = 0; }
        return this.smoothScroll.scrollToElement(selector, offset, duration, easeFunc);
    };
    /**
     * @param {?} to
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollXTo = /**
     * @param {?} to
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (to, duration, easeFunc) {
        return this.smoothScroll.scrollXTo(to, duration, easeFunc);
    };
    /**
     * @param {?} to
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollYTo = /**
     * @param {?} to
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (to, duration, easeFunc) {
        return this.smoothScroll.scrollYTo(to, duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToTop = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.smoothScroll.scrollToTop(duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToBottom = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.smoothScroll.scrollToBottom(duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToRight = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.smoothScroll.scrollToRight(duration, easeFunc);
    };
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    NgScrollbar.prototype.scrollToLeft = /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    function (duration, easeFunc) {
        return this.smoothScroll.scrollToLeft(duration, easeFunc);
    };
    NgScrollbar.decorators = [
        { type: Component, args: [{
                    selector: 'ng-scrollbar',
                    template: "<div class=\"ng-scrollbar-layout ng-scrollbar-x-layout\"\r\n     [class.ng-scrollbar-invert]=\"invertX\">\r\n\r\n  <div class=\"ng-scrollbar-layout ng-scrollbar-y-layout\"\r\n       [class.ng-scrollbar-invert]=\"invertY\">\r\n\r\n    <div class=\"ng-scroll-view-container\">\r\n      <div #view\r\n           cdkScrollable\r\n           smoothScroll\r\n           class=\"ng-scroll-view {{viewClass}}\"\r\n           [ngStyle]=\"hideNativeScrollbars\">\r\n        <ng-content></ng-content>\r\n      </div>\r\n    </div>\r\n\r\n    <ng-scrollbar-y #y\r\n                    *ngIf=\"!disabled && trackY\"\r\n                    [class.ng-scrollbar-visible]=\"showScrollbarY()\"\r\n                    [barClass]=\"barClass\"\r\n                    [thumbClass]=\"thumbClass\"\r\n                    [scrollToDuration]=\"scrollToDuration\">\r\n    </ng-scrollbar-y>\r\n  </div>\r\n\r\n  <ng-scrollbar-x #x\r\n                  *ngIf=\"!disabled && trackX\"\r\n                  [class.ng-scrollbar-visible]=\"showScrollbarX()\"\r\n                  [barClass]=\"barClass\"\r\n                  [thumbClass]=\"thumbClass\"\r\n                  [scrollToDuration]=\"scrollToDuration\">\r\n  </ng-scrollbar-x>\r\n\r\n</div>\r\n",
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    host: {
                        '[attr.customView]': '!!customViewPort',
                        '[attr.trackX]': 'trackX',
                        '[attr.trackY]': 'trackY',
                        '[attr.compact]': 'compact',
                        '[attr.autoHide]': 'shown === "hover"'
                    },
                    styles: [":host{display:block;overflow:hidden;--scrollbar-color:transparent;--scrollbar-container-color:transparent;--scrollbar-thumb-color:rgba(0, 0, 0, 0.2);--scrollbar-thumb-hover-color:rgba(0, 0, 0, 0.3);--scrollbar-border-radius:4px;--scrollbar-size:6px;--scrollbar-padding:8px;--scroll-view-margin:0;--scroll-view-color:transparent}:host[trackY=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>.ng-scroll-view{overflow-y:scroll}:host[trackX=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>.ng-scroll-view{overflow-x:scroll}:host>.ng-scrollbar-x-layout{flex-direction:column}:host>.ng-scrollbar-x-layout.ng-scrollbar-invert{flex-direction:column-reverse}:host>.ng-scrollbar-x-layout>.ng-scrollbar-y-layout{flex-direction:row}:host>.ng-scrollbar-x-layout>.ng-scrollbar-y-layout.ng-scrollbar-invert{flex-direction:row-reverse}:host[compact=true]>.ng-scrollbar-x-layout>ng-scrollbar-x{position:absolute;bottom:0}:host[compact=true]>.ng-scrollbar-x-layout.ng-scrollbar-invert>ng-scrollbar-x{top:0;bottom:unset}:host[compact=true]>.ng-scrollbar-x-layout>.ng-scrollbar-y-layout>ng-scrollbar-y{position:absolute;right:0;left:unset}:host[compact=true]>.ng-scrollbar-x-layout>.ng-scrollbar-y-layout.ng-scrollbar-invert>ng-scrollbar-y{right:unset;left:0}:host[autoHide=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>ng-scrollbar-y,:host[autoHide=true]>.ng-scrollbar-layout>ng-scrollbar-x{opacity:0;transition:opacity 120ms ease-out}:host[autoHide=true]:active>.ng-scrollbar-layout>.ng-scrollbar-layout>ng-scrollbar-y,:host[autoHide=true]:active>.ng-scrollbar-layout>ng-scrollbar-x,:host[autoHide=true]:focus>.ng-scrollbar-layout>.ng-scrollbar-layout>ng-scrollbar-y,:host[autoHide=true]:focus>.ng-scrollbar-layout>ng-scrollbar-x,:host[autoHide=true]:hover>.ng-scrollbar-layout>.ng-scrollbar-layout>ng-scrollbar-y,:host[autoHide=true]:hover>.ng-scrollbar-layout>ng-scrollbar-x{opacity:1;transition:opacity 340ms ease-out}.ng-scroll-view,.ng-scrollbar-layout,:host{position:relative;height:100%;width:100%}.ng-scrollbar-layout{display:flex;min-height:0}.ng-scroll-view-container{flex:1;position:relative;overflow:hidden;margin:var(--scroll-view-margin)}.ng-scroll-view{box-sizing:content-box;-webkit-transform:translateZ(0);transform:translateZ(0);background:var(--scroll-view-color);-webkit-overflow-scrolling:touch}ng-scrollbar-x,ng-scrollbar-y{display:none;box-sizing:border-box;padding:var(--scrollbar-padding);background:var(--scrollbar-container-color)}ng-scrollbar-x.ng-scrollbar-visible,ng-scrollbar-y.ng-scrollbar-visible{display:block}ng-scrollbar-y{top:0;bottom:0}ng-scrollbar-x{left:0;right:0}::ng-deep ng-scrollbar-y .ng-scrollbar{width:var(--scrollbar-size)}::ng-deep ng-scrollbar-y .ng-scrollbar-thumb{width:100%}::ng-deep ng-scrollbar-x .ng-scrollbar{height:var(--scrollbar-size)}::ng-deep ng-scrollbar-x .ng-scrollbar-thumb{height:100%}::ng-deep .ng-scrollbar{height:100%;width:100%;z-index:1;border-radius:var(--scrollbar-border-radius);background-color:var(--scrollbar-color)}::ng-deep .ng-scrollbar-thumb{box-sizing:border-box;position:relative;width:0;height:0;border-radius:inherit;background-color:var(--scrollbar-thumb-color);-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0);transition:height 150ms ease-out}::ng-deep .ng-scrollbar-thumb:active,::ng-deep .ng-scrollbar-thumb:hover{background-color:var(--scrollbar-thumb-hover-color)}::ng-deep cdk-virtual-scroll-viewport{height:100%}::ng-deep ng-scrollbar[customView=true] .ng-scroll-view{overflow:hidden!important}::ng-deep ng-scrollbar[trackY=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>.ng-scroll-view,::ng-deep ng-scrollbar[trackY=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>cdk-virtual-scroll-viewport{overflow-y:scroll}::ng-deep ng-scrollbar[trackX=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>.ng-scroll-view,::ng-deep ng-scrollbar[trackX=true]>.ng-scrollbar-layout>.ng-scrollbar-layout>.ng-scroll-view-container>cdk-virtual-scroll-viewport{overflow-x:scroll}"]
                }] }
    ];
    /** @nocollapse */
    NgScrollbar.ctorParameters = function () { return [
        { type: ChangeDetectorRef },
        { type: BreakpointObserver },
        { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] }
    ]; };
    NgScrollbar.propDecorators = {
        trackX: [{ type: Input }],
        trackY: [{ type: Input }],
        shown: [{ type: Input }],
        autoUpdate: [{ type: Input }],
        viewClass: [{ type: Input }],
        barClass: [{ type: Input }],
        thumbClass: [{ type: Input }],
        scrollToDuration: [{ type: Input }],
        compact: [{ type: Input }],
        invertY: [{ type: Input }],
        invertX: [{ type: Input }],
        disableOnBreakpoints: [{ type: Input }],
        disabled: [{ type: Input, args: ['disabled',] }],
        verticalScrollbar: [{ type: ViewChild, args: ['y', { read: ElementRef },] }],
        horizontalScrollbar: [{ type: ViewChild, args: ['x', { read: ElementRef },] }],
        scrollViewport: [{ type: ViewChild, args: [CdkScrollable,] }],
        viewSmoothScroll: [{ type: ViewChild, args: [SmoothScroll,] }],
        customViewPort: [{ type: ContentChild, args: [NgScrollbarView,] }]
    };
    return NgScrollbar;
}());
export { NgScrollbar };
if (false) {
    /**
     * Horizontal custom scrollbar
     * @type {?}
     */
    NgScrollbar.prototype.trackX;
    /**
     * Vertical custom Scrollbar
     * @type {?}
     */
    NgScrollbar.prototype.trackY;
    /**
     * Scrollbar visibility
     * @type {?}
     */
    NgScrollbar.prototype.shown;
    /**
     * Auto update scrollbars on content changes (Mutation Observer)
     * @type {?}
     */
    NgScrollbar.prototype.autoUpdate;
    /**
     * Viewport class
     * @type {?}
     */
    NgScrollbar.prototype.viewClass;
    /**
     * Scrollbars class
     * @type {?}
     */
    NgScrollbar.prototype.barClass;
    /**
     * Scrollbars thumbnails class
     * @type {?}
     */
    NgScrollbar.prototype.thumbClass;
    /**
     * The smooth scroll duration when a scrollbar is clicked
     * @type {?}
     */
    NgScrollbar.prototype.scrollToDuration;
    /**
     * Compact mode
     * @type {?}
     */
    NgScrollbar.prototype.compact;
    /**
     * Invert vertical scrollbar position, if set the scrollbar will be on the right
     * @type {?}
     */
    NgScrollbar.prototype.invertY;
    /**
     * Invert horizontal scrollbar position, if set the scrollbar will go the top
     * @type {?}
     */
    NgScrollbar.prototype.invertX;
    /**
     * Disable custom scrollbars on specific breakpoints
     * @type {?}
     */
    NgScrollbar.prototype.disableOnBreakpoints;
    /**
     * @type {?}
     * @private
     */
    NgScrollbar.prototype._disabled;
    /**
     * Scrollbars ElementRef
     * @type {?}
     */
    NgScrollbar.prototype.verticalScrollbar;
    /** @type {?} */
    NgScrollbar.prototype.horizontalScrollbar;
    /**
     * Default viewport and smoothScroll references
     * @type {?}
     */
    NgScrollbar.prototype.scrollViewport;
    /** @type {?} */
    NgScrollbar.prototype.viewSmoothScroll;
    /**
     * Virtual viewport and smoothScroll references
     * @type {?}
     */
    NgScrollbar.prototype.customViewPort;
    /**
     * Unsubscribe component observables on destroy
     * @type {?}
     * @private
     */
    NgScrollbar.prototype._unsubscribe$;
    /**
     * Observe content changes
     * @type {?}
     * @private
     */
    NgScrollbar.prototype._observer;
    /**
     * Steam that emits when scrollbar thumbnail needs to update (for internal uses)
     * @type {?}
     * @private
     */
    NgScrollbar.prototype._updateObserver;
    /** @type {?} */
    NgScrollbar.prototype.updateObserver;
    /**
     * @type {?}
     * @private
     */
    NgScrollbar.prototype._changeDetectorRef;
    /**
     * @type {?}
     * @private
     */
    NgScrollbar.prototype._breakpointObserver;
    /**
     * @type {?}
     * @private
     */
    NgScrollbar.prototype._platform;
}
//# sourceMappingURL=data:application/json;base64,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