/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Inject, NgZone, ChangeDetectionStrategy, forwardRef, PLATFORM_ID } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { fromEvent, animationFrameScheduler } from 'rxjs';
import { mergeMap, pluck, takeUntil, tap } from 'rxjs/operators';
import { NgScrollbar } from './ng-scrollbar';
import { NgScrollbarThumb } from './ng-scrollbar-thumb';
var NgScrollbarY = /** @class */ (function (_super) {
    tslib_1.__extends(NgScrollbarY, _super);
    function NgScrollbarY(_document, _parent, _platform, _zone) {
        var _this = _super.call(this, _parent, _platform, _zone) || this;
        _this._document = _document;
        _this._parent = _parent;
        _this._zone = _zone;
        return _this;
    }
    Object.defineProperty(NgScrollbarY.prototype, "thumbSize", {
        /**
         * Calculate scrollbar thumbnail size
         */
        get: /**
         * Calculate scrollbar thumbnail size
         * @return {?}
         */
        function () {
            /** @type {?} */
            var barClientHeight = this.bar.nativeElement.clientHeight;
            /** @type {?} */
            var viewClientHeight = this._view.clientHeight;
            /** @type {?} */
            var viewScrollHeight = this._view.scrollHeight;
            this._naturalThumbSize = barClientHeight / viewScrollHeight * barClientHeight;
            this._scrollMax = viewScrollHeight - viewClientHeight;
            return this.scrollBoundaries(this._naturalThumbSize, this._scrollMax);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Scrollbar click
     * @param e Mouse event
     */
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    NgScrollbarY.prototype.onScrollbarHolderClick = /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    function (e) {
        if (e.target === e.currentTarget) {
            /** @type {?} */
            var offsetY = e.offsetY - this._naturalThumbSize * .5;
            /** @type {?} */
            var thumbPositionPercentage = offsetY * 100 / this.bar.nativeElement.clientHeight;
            /** @type {?} */
            var value = thumbPositionPercentage * this._view.scrollHeight / 100;
            this._parent.scrollTo((/** @type {?} */ ({ top: value, duration: this.scrollToDuration }))).subscribe();
        }
    };
    /**
     * Update scrollbar
     */
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    NgScrollbarY.prototype.updateScrollbar = /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    function () {
        var _this = this;
        this._thumbSize = this.thumb.nativeElement.clientHeight;
        this._trackMax = this.bar.nativeElement.clientHeight - this._thumbSize;
        this._currPos = this._view.scrollTop * this._trackMax / this._scrollMax;
        this._zone.run((/**
         * @return {?}
         */
        function () {
            animationFrameScheduler.schedule((/**
             * @return {?}
             */
            function () {
                return _this.updateState({
                    transform: "translate3d(0, " + _this._currPos + "px, 0)",
                    height: _this.thumbSize + "px"
                });
            }));
        }));
    };
    /**
     * Start vertical thumb worker
     */
    /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    NgScrollbarY.prototype.startThumbEvents = /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var mouseDown$ = fromEvent(this.thumb.nativeElement, 'mousedown');
        /** @type {?} */
        var mouseMove$ = fromEvent(this._document, 'mousemove');
        /** @type {?} */
        var mouseUp$ = fromEvent(this._document, 'mouseup').pipe(tap((/**
         * @return {?}
         */
        function () { return _this._document.onselectstart = null; })));
        return mouseDown$.pipe(tap((/**
         * @return {?}
         */
        function () {
            _this._document.onselectstart = (/**
             * @return {?}
             */
            function () { return false; });
            // Initialize trackMax for before start dragging
            _this._trackMax = _this.bar.nativeElement.clientHeight - _this._thumbSize;
        })), pluck('offsetY'), mergeMap((/**
         * @param {?} mouseDownOffset
         * @return {?}
         */
        function (mouseDownOffset) { return mouseMove$.pipe(takeUntil(mouseUp$), pluck('clientY'), tap((/**
         * @param {?} mouseMoveClient
         * @return {?}
         */
        function (mouseMoveClient) {
            /** @type {?} */
            var offsetY = mouseMoveClient - _this.bar.nativeElement.getBoundingClientRect().top;
            /** @type {?} */
            var value = _this._scrollMax * (offsetY - mouseDownOffset) / _this._trackMax;
            _this._parent.scrollable.scrollTo({ top: value });
        }))); })));
    };
    NgScrollbarY.decorators = [
        { type: Component, args: [{
                    selector: 'ng-scrollbar-y',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: "\n    <div #bar class=\"ng-scrollbar {{barClass}}\" (mousedown)=\"onScrollbarHolderClick($event)\">\n      <div #thumb class=\"ng-scrollbar-thumb {{thumbClass}}\" [ngStyle]=\"scrollbarStyle | async\"></div>\n    </div>\n  "
                }] }
    ];
    /** @nocollapse */
    NgScrollbarY.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: NgScrollbar, decorators: [{ type: Inject, args: [forwardRef((/**
                         * @return {?}
                         */
                        function () { return NgScrollbar; })),] }] },
        { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] },
        { type: NgZone }
    ]; };
    return NgScrollbarY;
}(NgScrollbarThumb));
export { NgScrollbarY };
if (false) {
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarY.prototype._document;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarY.prototype._parent;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarY.prototype._zone;
}
//# sourceMappingURL=data:application/json;base64,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