/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Inject, NgZone, ChangeDetectionStrategy, forwardRef, PLATFORM_ID } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { Directionality } from '@angular/cdk/bidi';
import { fromEvent, animationFrameScheduler } from 'rxjs';
import { mergeMap, pluck, takeUntil, tap } from 'rxjs/operators';
import { NgScrollbar } from './ng-scrollbar';
import { NgScrollbarThumb } from './ng-scrollbar-thumb';
var NgScrollbarX = /** @class */ (function (_super) {
    tslib_1.__extends(NgScrollbarX, _super);
    function NgScrollbarX(_document, _parent, _platform, _dir, _zone) {
        var _this = _super.call(this, _parent, _platform, _zone) || this;
        _this._document = _document;
        _this._parent = _parent;
        _this._dir = _dir;
        _this._zone = _zone;
        return _this;
    }
    Object.defineProperty(NgScrollbarX.prototype, "thumbSize", {
        /**
         * Calculate scrollbar thumbnail size
         */
        get: /**
         * Calculate scrollbar thumbnail size
         * @return {?}
         */
        function () {
            /** @type {?} */
            var barClientWidth = this.bar.nativeElement.clientWidth;
            /** @type {?} */
            var viewClientWidth = this._view.clientWidth;
            /** @type {?} */
            var viewScrollWidth = this._view.scrollWidth;
            this._naturalThumbSize = barClientWidth / viewScrollWidth * barClientWidth;
            this._scrollMax = viewScrollWidth - viewClientWidth;
            return this.scrollBoundaries(this._naturalThumbSize, this._scrollMax);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Scrollbar click
     * @param e Mouse event
     */
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    NgScrollbarX.prototype.onScrollbarHolderClick = /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    function (e) {
        if (e.target === e.currentTarget) {
            /** @type {?} */
            var offsetX = e.offsetX - this._naturalThumbSize * .5;
            /** @type {?} */
            var thumbPositionPercentage = offsetX * 100 / this.bar.nativeElement.clientWidth;
            /** @type {?} */
            var value = thumbPositionPercentage * this._view.scrollWidth / 100;
            this._parent.scrollTo((/** @type {?} */ ({ left: value, duration: this.scrollToDuration }))).subscribe();
        }
    };
    /**
     * Update scrollbar
     */
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    NgScrollbarX.prototype.updateScrollbar = /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    function () {
        var _this = this;
        this._thumbSize = this.thumb.nativeElement.clientWidth;
        this._trackMax = this.bar.nativeElement.clientWidth - this._thumbSize;
        this._currPos = this._view.scrollLeft * this._trackMax / this._scrollMax;
        this._zone.run((/**
         * @return {?}
         */
        function () {
            animationFrameScheduler.schedule((/**
             * @return {?}
             */
            function () {
                return _this.updateState({
                    transform: "translate3d(" + (_this._dir.value === 'rtl' ? _this._currPos - _this._trackMax : _this._currPos) + "px, 0, 0)",
                    width: _this.thumbSize + "px"
                });
            }));
        }));
    };
    /**
     * Start horizontal thumb worker
     */
    /**
     * Start horizontal thumb worker
     * @protected
     * @return {?}
     */
    NgScrollbarX.prototype.startThumbEvents = /**
     * Start horizontal thumb worker
     * @protected
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var mouseDown$ = fromEvent(this.thumb.nativeElement, 'mousedown');
        /** @type {?} */
        var mouseMove$ = fromEvent(this._document, 'mousemove');
        /** @type {?} */
        var mouseUp$ = fromEvent(this._document, 'mouseup').pipe(tap((/**
         * @return {?}
         */
        function () { return _this._document.onselectstart = null; })));
        return mouseDown$.pipe(tap((/**
         * @return {?}
         */
        function () {
            _this._document.onselectstart = (/**
             * @return {?}
             */
            function () { return false; });
            // Initialize trackMax for before start dragging
            _this._trackMax = _this.bar.nativeElement.clientWidth - _this._thumbSize;
        })), pluck('offsetX'), mergeMap((/**
         * @param {?} mouseDownOffset
         * @return {?}
         */
        function (mouseDownOffset) { return mouseMove$.pipe(takeUntil(mouseUp$), pluck('clientX'), tap((/**
         * @param {?} mouseMoveClient
         * @return {?}
         */
        function (mouseMoveClient) {
            /** @type {?} */
            var offsetX = mouseMoveClient - _this.bar.nativeElement.getBoundingClientRect().left;
            /** @type {?} */
            var value = _this._scrollMax * (offsetX - mouseDownOffset) / _this._trackMax;
            if (_this._dir.value === 'rtl') {
                value = value === 0 ? offsetX - _this._trackMax : value;
            }
            _this._parent.scrollable.scrollTo({ left: value });
        }))); })));
    };
    NgScrollbarX.decorators = [
        { type: Component, args: [{
                    selector: 'ng-scrollbar-x',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: "\n    <div #bar class=\"ng-scrollbar {{barClass}}\" (mousedown)=\"onScrollbarHolderClick($event)\">\n      <div #thumb class=\"ng-scrollbar-thumb {{thumbClass}}\" [ngStyle]=\"scrollbarStyle | async\"></div>\n    </div>\n  "
                }] }
    ];
    /** @nocollapse */
    NgScrollbarX.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: NgScrollbar, decorators: [{ type: Inject, args: [forwardRef((/**
                         * @return {?}
                         */
                        function () { return NgScrollbar; })),] }] },
        { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] },
        { type: Directionality },
        { type: NgZone }
    ]; };
    return NgScrollbarX;
}(NgScrollbarThumb));
export { NgScrollbarX };
if (false) {
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarX.prototype._document;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarX.prototype._parent;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarX.prototype._dir;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarX.prototype._zone;
}
//# sourceMappingURL=data:application/json;base64,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