/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Input, ViewChild, ElementRef } from '@angular/core';
import { isPlatformBrowser } from '@angular/common';
import { BehaviorSubject, Subscription } from 'rxjs';
import { debounceTime, throttleTime, tap } from 'rxjs/operators';
var NgScrollbarThumb = /** @class */ (function () {
    function NgScrollbarThumb(_parent, _platform, _zone) {
        this._parent = _parent;
        this._platform = _platform;
        this._zone = _zone;
        this._minThumbSize = 20;
        this._naturalThumbSize = 0;
        this._thumbSize = 0;
        this._trackMax = 0;
        this._scrollMax = 0;
        this._currPos = 0;
        this._scroll$ = Subscription.EMPTY;
        this._thumbDrag$ = Subscription.EMPTY;
        this._updateObserver$ = Subscription.EMPTY;
        this._state = new BehaviorSubject({
            transform: 'translate3d(0, 0, 0)'
        });
        /**
         * Scrollbar styles
         */
        this.scrollbarStyle = this._state.asObservable();
    }
    Object.defineProperty(NgScrollbarThumb.prototype, "thumbSize", {
        get: /**
         * @return {?}
         */
        function () {
            return 0;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    NgScrollbarThumb.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Avoid SSR Error
        if (isPlatformBrowser(this._platform)) {
            this._view = this._parent.view;
            // Start view scroll event
            this._scroll$ = this._parent.scrollable.elementScrolled()
                .subscribe((/**
             * @return {?}
             */
            function () { return _this.updateScrollbar(); }));
            // Start scrollbar thumbnail drag events
            this._zone.runOutsideAngular((/**
             * @return {?}
             */
            function () {
                return _this._thumbDrag$ = _this.startThumbEvents().subscribe();
            }));
            // Update scrollbar thumbnail size on content changes
            this._updateObserver$ = this._parent.updateObserver.pipe(throttleTime(200), tap((/**
             * @return {?}
             */
            function () { return _this.updateScrollbar(); })), 
            // Make sure scrollbar thumbnail position is correct after the new content is rendered
            debounceTime(200), tap((/**
             * @return {?}
             */
            function () { return _this.updateScrollbar(); }))).subscribe();
            // Initialize scrollbar
            setTimeout((/**
             * @return {?}
             */
            function () { return _this.updateScrollbar(); }), 200);
        }
    };
    /**
     * @return {?}
     */
    NgScrollbarThumb.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this._scroll$.unsubscribe();
        this._thumbDrag$.unsubscribe();
        this._updateObserver$.unsubscribe();
    };
    /**
     * Scrollbar click
     * @param e Mouse event
     */
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    NgScrollbarThumb.prototype.onScrollbarHolderClick = /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    function (e) {
    };
    /**
     * Update scrollbar
     */
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    NgScrollbarThumb.prototype.updateScrollbar = /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    function () {
    };
    /**
     * Start vertical thumb worker
     */
    /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    NgScrollbarThumb.prototype.startThumbEvents = /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    function () {
        return undefined;
    };
    /**
     * Get scrollbar thumb size
     * @param naturalThumbSize
     * @param scrollMax
     */
    /**
     * Get scrollbar thumb size
     * @protected
     * @param {?} naturalThumbSize
     * @param {?} scrollMax
     * @return {?}
     */
    NgScrollbarThumb.prototype.scrollBoundaries = /**
     * Get scrollbar thumb size
     * @protected
     * @param {?} naturalThumbSize
     * @param {?} scrollMax
     * @return {?}
     */
    function (naturalThumbSize, scrollMax) {
        return (naturalThumbSize < this._minThumbSize) ? this._minThumbSize : scrollMax ? naturalThumbSize : 0;
    };
    /**
     * @protected
     * @param {?} state
     * @return {?}
     */
    NgScrollbarThumb.prototype.updateState = /**
     * @protected
     * @param {?} state
     * @return {?}
     */
    function (state) {
        this._state.next(tslib_1.__assign({}, this._state.value, state));
    };
    NgScrollbarThumb.propDecorators = {
        barClass: [{ type: Input }],
        thumbClass: [{ type: Input }],
        scrollToDuration: [{ type: Input }],
        bar: [{ type: ViewChild, args: ['bar',] }],
        thumb: [{ type: ViewChild, args: ['thumb',] }]
    };
    return NgScrollbarThumb;
}());
export { NgScrollbarThumb };
if (false) {
    /**
     * Scrollbar class
     * @type {?}
     */
    NgScrollbarThumb.prototype.barClass;
    /**
     * Scrollbar thumbnail class
     * @type {?}
     */
    NgScrollbarThumb.prototype.thumbClass;
    /**
     * The scroll duration when scrollbar (not the thumbnail) is clicked
     * @type {?}
     */
    NgScrollbarThumb.prototype.scrollToDuration;
    /** @type {?} */
    NgScrollbarThumb.prototype.bar;
    /** @type {?} */
    NgScrollbarThumb.prototype.thumb;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._minThumbSize;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._naturalThumbSize;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._thumbSize;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._trackMax;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._scrollMax;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._currPos;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._scroll$;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._thumbDrag$;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._updateObserver$;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._view;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._state;
    /**
     * Scrollbar styles
     * @type {?}
     */
    NgScrollbarThumb.prototype.scrollbarStyle;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._parent;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._platform;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._zone;
}
//# sourceMappingURL=data:application/json;base64,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