/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Directive, ElementRef, Inject, PLATFORM_ID } from '@angular/core';
import { isPlatformBrowser } from '@angular/common';
import { supportsScrollBehavior } from '@angular/cdk/platform';
import { from, of, animationFrameScheduler } from 'rxjs';
/**
 * @record
 */
export function SmoothScrollOptions() { }
if (false) {
    /** @type {?|undefined} */
    SmoothScrollOptions.prototype.top;
    /** @type {?|undefined} */
    SmoothScrollOptions.prototype.left;
    /** @type {?} */
    SmoothScrollOptions.prototype.offsetTop;
    /** @type {?} */
    SmoothScrollOptions.prototype.offsetLeft;
    /** @type {?} */
    SmoothScrollOptions.prototype.duration;
    /** @type {?} */
    SmoothScrollOptions.prototype.scrollFunc;
    /** @type {?} */
    SmoothScrollOptions.prototype.easeFunc;
}
/**
 * @record
 */
export function ScrollToOptions() { }
if (false) {
    /** @type {?|undefined} */
    ScrollToOptions.prototype.top;
    /** @type {?|undefined} */
    ScrollToOptions.prototype.left;
    /** @type {?|undefined} */
    ScrollToOptions.prototype.duration;
    /** @type {?|undefined} */
    ScrollToOptions.prototype.easeFunc;
}
export class SmoothScroll {
    /**
     * @param {?} _platform
     * @param {?} el
     */
    constructor(_platform, el) {
        this._platform = _platform;
        this.view = el.nativeElement;
    }
    /**
     * @private
     * @param {?} left
     * @param {?} top
     * @return {?}
     */
    scrollFunc(left, top) {
        if (supportsScrollBehavior()) {
            this.view.scrollTo({ top, left });
        }
        else {
            this.view.scrollTop = top;
            this.view.scrollLeft = left;
        }
    }
    /**
     * @param {?} options
     * @return {?}
     */
    scrollTo(options) {
        // Avoid SSR error
        if (isPlatformBrowser(this._platform)) {
            /** @type {?} */
            const scrollFunc = (/**
             * @param {?} left
             * @param {?} top
             * @return {?}
             */
            (left, top) => {
                if (supportsScrollBehavior()) {
                    this.view.scrollTo({ top, left });
                }
                else {
                    this.view.scrollTop = top;
                    this.view.scrollLeft = left;
                }
            });
            if (options.duration) {
                /** @type {?} */
                const smoothScrollOptions = {
                    top: options.top,
                    left: options.left,
                    duration: options.duration,
                    easeFunc: options.easeFunc || easeInOutQuad,
                    offsetTop: this.view.scrollTop,
                    offsetLeft: this.view.scrollLeft,
                    scrollFunc
                };
                return from(smoothScroll(smoothScrollOptions));
            }
            this.scrollFunc(options.left, options.top);
        }
        return of();
    }
    /**
     * @param {?} selector
     * @param {?=} offset
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    scrollToElement(selector, offset = 0, duration, easeFunc) {
        /** @type {?} */
        const target = this.view.querySelector(selector);
        return target ? this.scrollTo({ left: target.offsetLeft, top: target.offsetTop - offset, duration, easeFunc }) : of();
    }
    /**
     * @param {?} left
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    scrollXTo(left, duration, easeFunc) {
        return this.scrollTo({ left, duration, easeFunc });
    }
    /**
     * @param {?} top
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    scrollYTo(top, duration, easeFunc) {
        return this.scrollTo({ top, duration, easeFunc });
    }
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    scrollToTop(duration, easeFunc) {
        return this.scrollYTo(0, duration, easeFunc);
    }
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    scrollToBottom(duration, easeFunc) {
        return this.scrollYTo(this.view.scrollHeight - this.view.clientHeight, duration, easeFunc);
    }
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    scrollToRight(duration, easeFunc) {
        return this.scrollXTo(this.view.scrollWidth, duration, easeFunc);
    }
    /**
     * @param {?=} duration
     * @param {?=} easeFunc
     * @return {?}
     */
    scrollToLeft(duration, easeFunc) {
        return this.scrollXTo(0, duration, easeFunc);
    }
}
SmoothScroll.decorators = [
    { type: Directive, args: [{
                selector: '[smoothScroll], [smooth-scroll]'
            },] }
];
/** @nocollapse */
SmoothScroll.ctorParameters = () => [
    { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] },
    { type: ElementRef }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    SmoothScroll.prototype.view;
    /**
     * @type {?}
     * @private
     */
    SmoothScroll.prototype._platform;
}
/**
 * @param {?} options
 * @return {?}
 */
export function smoothScroll(options) {
    return new Promise((/**
     * @param {?} resolve
     * @return {?}
     */
    resolve => {
        /** @type {?} */
        let currentTime = 0;
        /** @type {?} */
        const increment = 10;
        /** @type {?} */
        let valX = options.offsetLeft;
        /** @type {?} */
        let valY = options.offsetTop;
        /** @type {?} */
        const animateScroll = (/**
         * @return {?}
         */
        () => {
            // increment the time
            currentTime += increment;
            // find the value with the easing function
            if (typeof options.left !== 'undefined') {
                /** @type {?} */
                const deltaX = options.left - options.offsetLeft;
                valX = options.easeFunc(currentTime, options.offsetLeft, deltaX, options.duration);
            }
            if (typeof options.top !== 'undefined') {
                /** @type {?} */
                const deltaY = options.top - options.offsetTop;
                valY = options.easeFunc(currentTime, options.offsetTop, deltaY, options.duration);
            }
            // scroll to position
            options.scrollFunc(valX, valY);
            // do the animation unless its over
            if (currentTime < options.duration) {
                animationFrameScheduler.schedule(animateScroll);
            }
            else {
                resolve();
            }
        });
        animateScroll();
    }));
}
// easing functions http://goo.gl/5HLl8
/**
 * @param {?} t
 * @param {?} b
 * @param {?} c
 * @param {?} d
 * @return {?}
 */
export function easeInOutQuad(t, b, c, d) {
    t /= d / 2;
    if (t < 1) {
        return (c / 2) * t * t + b;
    }
    t--;
    return (-c / 2) * (t * (t - 2) - 1) + b;
}
/**
 * @param {?} t
 * @param {?} b
 * @param {?} c
 * @param {?} d
 * @return {?}
 */
export function easeInCubic(t, b, c, d) {
    /** @type {?} */
    const tc = (t /= d) * t * t;
    return b + c * tc;
}
/**
 * @param {?} t
 * @param {?} b
 * @param {?} c
 * @param {?} d
 * @return {?}
 */
export function inOutQuintic(t, b, c, d) {
    /** @type {?} */
    const ts = (t /= d) * t;
    /** @type {?} */
    const tc = ts * t;
    return b + c * (6 * tc * ts + -15 * ts * ts + 10 * tc);
}
//# sourceMappingURL=data:application/json;base64,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