/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Inject, NgZone, ChangeDetectionStrategy, forwardRef, PLATFORM_ID } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { fromEvent, animationFrameScheduler } from 'rxjs';
import { mergeMap, pluck, takeUntil, tap } from 'rxjs/operators';
import { NgScrollbar } from './ng-scrollbar';
import { NgScrollbarThumb } from './ng-scrollbar-thumb';
export class NgScrollbarY extends NgScrollbarThumb {
    /**
     * @param {?} _document
     * @param {?} _parent
     * @param {?} _platform
     * @param {?} _zone
     */
    constructor(_document, _parent, _platform, _zone) {
        super(_parent, _platform, _zone);
        this._document = _document;
        this._parent = _parent;
        this._zone = _zone;
    }
    /**
     * Calculate scrollbar thumbnail size
     * @return {?}
     */
    get thumbSize() {
        /** @type {?} */
        const barClientHeight = this.bar.nativeElement.clientHeight;
        /** @type {?} */
        const viewClientHeight = this._view.clientHeight;
        /** @type {?} */
        const viewScrollHeight = this._view.scrollHeight;
        this._naturalThumbSize = barClientHeight / viewScrollHeight * barClientHeight;
        this._scrollMax = viewScrollHeight - viewClientHeight;
        return this.scrollBoundaries(this._naturalThumbSize, this._scrollMax);
    }
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    onScrollbarHolderClick(e) {
        if (e.target === e.currentTarget) {
            /** @type {?} */
            const offsetY = e.offsetY - this._naturalThumbSize * .5;
            /** @type {?} */
            const thumbPositionPercentage = offsetY * 100 / this.bar.nativeElement.clientHeight;
            /** @type {?} */
            const value = thumbPositionPercentage * this._view.scrollHeight / 100;
            this._parent.scrollTo((/** @type {?} */ ({ top: value, duration: this.scrollToDuration }))).subscribe();
        }
    }
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    updateScrollbar() {
        this._thumbSize = this.thumb.nativeElement.clientHeight;
        this._trackMax = this.bar.nativeElement.clientHeight - this._thumbSize;
        this._currPos = this._view.scrollTop * this._trackMax / this._scrollMax;
        this._zone.run((/**
         * @return {?}
         */
        () => {
            animationFrameScheduler.schedule((/**
             * @return {?}
             */
            () => this.updateState({
                transform: `translate3d(0, ${this._currPos}px, 0)`,
                height: `${this.thumbSize}px`
            })));
        }));
    }
    /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    startThumbEvents() {
        /** @type {?} */
        const mouseDown$ = fromEvent(this.thumb.nativeElement, 'mousedown');
        /** @type {?} */
        const mouseMove$ = fromEvent(this._document, 'mousemove');
        /** @type {?} */
        const mouseUp$ = fromEvent(this._document, 'mouseup').pipe(tap((/**
         * @return {?}
         */
        () => this._document.onselectstart = null)));
        return mouseDown$.pipe(tap((/**
         * @return {?}
         */
        () => {
            this._document.onselectstart = (/**
             * @return {?}
             */
            () => false);
            // Initialize trackMax for before start dragging
            this._trackMax = this.bar.nativeElement.clientHeight - this._thumbSize;
        })), pluck('offsetY'), mergeMap((/**
         * @param {?} mouseDownOffset
         * @return {?}
         */
        (mouseDownOffset) => mouseMove$.pipe(takeUntil(mouseUp$), pluck('clientY'), tap((/**
         * @param {?} mouseMoveClient
         * @return {?}
         */
        (mouseMoveClient) => {
            /** @type {?} */
            const offsetY = mouseMoveClient - this.bar.nativeElement.getBoundingClientRect().top;
            /** @type {?} */
            const value = this._scrollMax * (offsetY - mouseDownOffset) / this._trackMax;
            this._parent.scrollable.scrollTo({ top: value });
        }))))));
    }
}
NgScrollbarY.decorators = [
    { type: Component, args: [{
                selector: 'ng-scrollbar-y',
                changeDetection: ChangeDetectionStrategy.OnPush,
                template: `
    <div #bar class="ng-scrollbar {{barClass}}" (mousedown)="onScrollbarHolderClick($event)">
      <div #thumb class="ng-scrollbar-thumb {{thumbClass}}" [ngStyle]="scrollbarStyle | async"></div>
    </div>
  `
            }] }
];
/** @nocollapse */
NgScrollbarY.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
    { type: NgScrollbar, decorators: [{ type: Inject, args: [forwardRef((/**
                     * @return {?}
                     */
                    () => NgScrollbar)),] }] },
    { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] },
    { type: NgZone }
];
if (false) {
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarY.prototype._document;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarY.prototype._parent;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarY.prototype._zone;
}
//# sourceMappingURL=data:application/json;base64,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