/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Inject, NgZone, ChangeDetectionStrategy, forwardRef, PLATFORM_ID } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { Directionality } from '@angular/cdk/bidi';
import { fromEvent, animationFrameScheduler } from 'rxjs';
import { mergeMap, pluck, takeUntil, tap } from 'rxjs/operators';
import { NgScrollbar } from './ng-scrollbar';
import { NgScrollbarThumb } from './ng-scrollbar-thumb';
export class NgScrollbarX extends NgScrollbarThumb {
    /**
     * @param {?} _document
     * @param {?} _parent
     * @param {?} _platform
     * @param {?} _dir
     * @param {?} _zone
     */
    constructor(_document, _parent, _platform, _dir, _zone) {
        super(_parent, _platform, _zone);
        this._document = _document;
        this._parent = _parent;
        this._dir = _dir;
        this._zone = _zone;
    }
    /**
     * Calculate scrollbar thumbnail size
     * @return {?}
     */
    get thumbSize() {
        /** @type {?} */
        const barClientWidth = this.bar.nativeElement.clientWidth;
        /** @type {?} */
        const viewClientWidth = this._view.clientWidth;
        /** @type {?} */
        const viewScrollWidth = this._view.scrollWidth;
        this._naturalThumbSize = barClientWidth / viewScrollWidth * barClientWidth;
        this._scrollMax = viewScrollWidth - viewClientWidth;
        return this.scrollBoundaries(this._naturalThumbSize, this._scrollMax);
    }
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    onScrollbarHolderClick(e) {
        if (e.target === e.currentTarget) {
            /** @type {?} */
            const offsetX = e.offsetX - this._naturalThumbSize * .5;
            /** @type {?} */
            const thumbPositionPercentage = offsetX * 100 / this.bar.nativeElement.clientWidth;
            /** @type {?} */
            const value = thumbPositionPercentage * this._view.scrollWidth / 100;
            this._parent.scrollTo((/** @type {?} */ ({ left: value, duration: this.scrollToDuration }))).subscribe();
        }
    }
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    updateScrollbar() {
        this._thumbSize = this.thumb.nativeElement.clientWidth;
        this._trackMax = this.bar.nativeElement.clientWidth - this._thumbSize;
        this._currPos = this._view.scrollLeft * this._trackMax / this._scrollMax;
        this._zone.run((/**
         * @return {?}
         */
        () => {
            animationFrameScheduler.schedule((/**
             * @return {?}
             */
            () => this.updateState({
                transform: `translate3d(${this._dir.value === 'rtl' ? this._currPos - this._trackMax : this._currPos}px, 0, 0)`,
                width: `${this.thumbSize}px`
            })));
        }));
    }
    /**
     * Start horizontal thumb worker
     * @protected
     * @return {?}
     */
    startThumbEvents() {
        /** @type {?} */
        const mouseDown$ = fromEvent(this.thumb.nativeElement, 'mousedown');
        /** @type {?} */
        const mouseMove$ = fromEvent(this._document, 'mousemove');
        /** @type {?} */
        const mouseUp$ = fromEvent(this._document, 'mouseup').pipe(tap((/**
         * @return {?}
         */
        () => this._document.onselectstart = null)));
        return mouseDown$.pipe(tap((/**
         * @return {?}
         */
        () => {
            this._document.onselectstart = (/**
             * @return {?}
             */
            () => false);
            // Initialize trackMax for before start dragging
            this._trackMax = this.bar.nativeElement.clientWidth - this._thumbSize;
        })), pluck('offsetX'), mergeMap((/**
         * @param {?} mouseDownOffset
         * @return {?}
         */
        (mouseDownOffset) => mouseMove$.pipe(takeUntil(mouseUp$), pluck('clientX'), tap((/**
         * @param {?} mouseMoveClient
         * @return {?}
         */
        (mouseMoveClient) => {
            /** @type {?} */
            const offsetX = mouseMoveClient - this.bar.nativeElement.getBoundingClientRect().left;
            /** @type {?} */
            let value = this._scrollMax * (offsetX - mouseDownOffset) / this._trackMax;
            if (this._dir.value === 'rtl') {
                value = value === 0 ? offsetX - this._trackMax : value;
            }
            this._parent.scrollable.scrollTo({ left: value });
        }))))));
    }
}
NgScrollbarX.decorators = [
    { type: Component, args: [{
                selector: 'ng-scrollbar-x',
                changeDetection: ChangeDetectionStrategy.OnPush,
                template: `
    <div #bar class="ng-scrollbar {{barClass}}" (mousedown)="onScrollbarHolderClick($event)">
      <div #thumb class="ng-scrollbar-thumb {{thumbClass}}" [ngStyle]="scrollbarStyle | async"></div>
    </div>
  `
            }] }
];
/** @nocollapse */
NgScrollbarX.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
    { type: NgScrollbar, decorators: [{ type: Inject, args: [forwardRef((/**
                     * @return {?}
                     */
                    () => NgScrollbar)),] }] },
    { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] },
    { type: Directionality },
    { type: NgZone }
];
if (false) {
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarX.prototype._document;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarX.prototype._parent;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarX.prototype._dir;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarX.prototype._zone;
}
//# sourceMappingURL=data:application/json;base64,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