/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Input, ViewChild, ElementRef } from '@angular/core';
import { isPlatformBrowser } from '@angular/common';
import { BehaviorSubject, Subscription } from 'rxjs';
import { debounceTime, throttleTime, tap } from 'rxjs/operators';
export class NgScrollbarThumb {
    /**
     * @param {?} _parent
     * @param {?} _platform
     * @param {?} _zone
     */
    constructor(_parent, _platform, _zone) {
        this._parent = _parent;
        this._platform = _platform;
        this._zone = _zone;
        this._minThumbSize = 20;
        this._naturalThumbSize = 0;
        this._thumbSize = 0;
        this._trackMax = 0;
        this._scrollMax = 0;
        this._currPos = 0;
        this._scroll$ = Subscription.EMPTY;
        this._thumbDrag$ = Subscription.EMPTY;
        this._updateObserver$ = Subscription.EMPTY;
        this._state = new BehaviorSubject({
            transform: 'translate3d(0, 0, 0)'
        });
        /**
         * Scrollbar styles
         */
        this.scrollbarStyle = this._state.asObservable();
    }
    /**
     * @return {?}
     */
    get thumbSize() {
        return 0;
    }
    /**
     * @return {?}
     */
    ngAfterViewInit() {
        // Avoid SSR Error
        if (isPlatformBrowser(this._platform)) {
            this._view = this._parent.view;
            // Start view scroll event
            this._scroll$ = this._parent.scrollable.elementScrolled()
                .subscribe((/**
             * @return {?}
             */
            () => this.updateScrollbar()));
            // Start scrollbar thumbnail drag events
            this._zone.runOutsideAngular((/**
             * @return {?}
             */
            () => this._thumbDrag$ = this.startThumbEvents().subscribe()));
            // Update scrollbar thumbnail size on content changes
            this._updateObserver$ = this._parent.updateObserver.pipe(throttleTime(200), tap((/**
             * @return {?}
             */
            () => this.updateScrollbar())), 
            // Make sure scrollbar thumbnail position is correct after the new content is rendered
            debounceTime(200), tap((/**
             * @return {?}
             */
            () => this.updateScrollbar()))).subscribe();
            // Initialize scrollbar
            setTimeout((/**
             * @return {?}
             */
            () => this.updateScrollbar()), 200);
        }
    }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        this._scroll$.unsubscribe();
        this._thumbDrag$.unsubscribe();
        this._updateObserver$.unsubscribe();
    }
    /**
     * Scrollbar click
     * @param {?} e Mouse event
     * @return {?}
     */
    onScrollbarHolderClick(e) {
    }
    /**
     * Update scrollbar
     * @protected
     * @return {?}
     */
    updateScrollbar() {
    }
    /**
     * Start vertical thumb worker
     * @protected
     * @return {?}
     */
    startThumbEvents() {
        return undefined;
    }
    /**
     * Get scrollbar thumb size
     * @protected
     * @param {?} naturalThumbSize
     * @param {?} scrollMax
     * @return {?}
     */
    scrollBoundaries(naturalThumbSize, scrollMax) {
        return (naturalThumbSize < this._minThumbSize) ? this._minThumbSize : scrollMax ? naturalThumbSize : 0;
    }
    /**
     * @protected
     * @param {?} state
     * @return {?}
     */
    updateState(state) {
        this._state.next(Object.assign({}, this._state.value, state));
    }
}
NgScrollbarThumb.propDecorators = {
    barClass: [{ type: Input }],
    thumbClass: [{ type: Input }],
    scrollToDuration: [{ type: Input }],
    bar: [{ type: ViewChild, args: ['bar',] }],
    thumb: [{ type: ViewChild, args: ['thumb',] }]
};
if (false) {
    /**
     * Scrollbar class
     * @type {?}
     */
    NgScrollbarThumb.prototype.barClass;
    /**
     * Scrollbar thumbnail class
     * @type {?}
     */
    NgScrollbarThumb.prototype.thumbClass;
    /**
     * The scroll duration when scrollbar (not the thumbnail) is clicked
     * @type {?}
     */
    NgScrollbarThumb.prototype.scrollToDuration;
    /** @type {?} */
    NgScrollbarThumb.prototype.bar;
    /** @type {?} */
    NgScrollbarThumb.prototype.thumb;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._minThumbSize;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._naturalThumbSize;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._thumbSize;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._trackMax;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._scrollMax;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._currPos;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._scroll$;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._thumbDrag$;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._updateObserver$;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._view;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._state;
    /**
     * Scrollbar styles
     * @type {?}
     */
    NgScrollbarThumb.prototype.scrollbarStyle;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._parent;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._platform;
    /**
     * @type {?}
     * @protected
     */
    NgScrollbarThumb.prototype._zone;
}
//# sourceMappingURL=data:application/json;base64,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