import { EventEmitter, NgZone, OnDestroy, Renderer2, ElementRef } from '@angular/core';
import { UploadEvent } from './upload-event.model';
export declare class FileComponent implements OnDestroy {
    private zone;
    private renderer;
    accept: string;
    dropZoneLabel: string;
    /** @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead. */
    /** @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead. */
    headertext: string;
    dropZoneClassName: string;
    /** @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead. */
    /** @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead. */
    customstyle: string;
    contentClassName: string;
    /** @deprecated Will be removed in the next major version. Use `contentClassName` instead. */
    /** @deprecated Will be removed in the next major version. Use `contentClassName` instead. */
    customContentStyle: string;
    disabled: boolean;
    /** @deprecated Will be removed in the next major version. Use `disabled` instead. */
    /** @deprecated Will be removed in the next major version. Use `disabled` instead. */
    disableIf: boolean;
    showBrowseBtn: boolean;
    browseBtnClassName: string;
    /** @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead. */
    /** @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead. */
    customBtnStyling: string;
    browseBtnLabel: string;
    onFileDrop: EventEmitter<UploadEvent>;
    onFileOver: EventEmitter<any>;
    onFileLeave: EventEmitter<any>;
    fileSelector: ElementRef;
    isDraggingOverDropZone: boolean;
    private globalDraggingInProgress;
    private globalDragStartListener;
    private globalDragEndListener;
    private files;
    private numOfActiveReadEntries;
    private helperFormEl;
    private fileInputPlaceholderEl;
    private dropEventTimerSubscription;
    private _disabled;
    constructor(zone: NgZone, renderer: Renderer2);
    ngOnDestroy(): void;
    onDragOver(event: Event): void;
    onDragLeave(event: Event): void;
    dropFiles(event: DragEvent): void;
    onBrowseButtonClick(event: MouseEvent): void;
    /**
     * Processes the change event of the file input and adds the given files.
     * @param Event event
     */
    uploadFiles(event: Event): void;
    private checkFiles;
    private traverseFileTree;
    /**
     * Clears any added files from the file input element so the same file can subsequently be added multiple times.
     */
    private resetFileInput;
    /**
     * Get a cached HTML form element as a helper element to clear the file input element.
     */
    private getHelperFormElement;
    /**
     * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
     */
    private getFileInputPlaceholderElement;
    private canGetAsEntry;
    private isDropzoneDisabled;
    private addToQueue;
    private preventAndStop;
}
