import { Component, Input, Output, EventEmitter, NgZone, Renderer2, ViewChild, NgModule } from '@angular/core';
import { timer } from 'rxjs';
import { CommonModule } from '@angular/common';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
/**
 * fileEntry is an instance of {\@link FileSystemFileEntry} or {\@link FileSystemDirectoryEntry}.
 * Which one is it can be checked using {\@link FileSystemEntry.isFile} or {\@link FileSystemEntry.isDirectory}
 * properties of the given {\@link FileSystemEntry}.
 */
var  /**
 * fileEntry is an instance of {\@link FileSystemFileEntry} or {\@link FileSystemDirectoryEntry}.
 * Which one is it can be checked using {\@link FileSystemEntry.isFile} or {\@link FileSystemEntry.isDirectory}
 * properties of the given {\@link FileSystemEntry}.
 */
UploadFile = /** @class */ (function () {
    function UploadFile(relativePath, fileEntry) {
        this.relativePath = relativePath;
        this.fileEntry = fileEntry;
    }
    return UploadFile;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
var UploadEvent = /** @class */ (function () {
    function UploadEvent(files) {
        this.files = files;
    }
    return UploadEvent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
var FileComponent = /** @class */ (function () {
    function FileComponent(zone, renderer) {
        var _this = this;
        this.zone = zone;
        this.renderer = renderer;
        this.accept = '*';
        this.dropZoneLabel = '';
        this.dropZoneClassName = 'ngx-file-drop__drop-zone drop-zone';
        this.contentClassName = 'ngx-file-drop__content content';
        this.showBrowseBtn = false;
        this.browseBtnClassName = 'btn btn-primary btn-xs ngx-file-drop__browse-btn';
        this.browseBtnLabel = 'Browse files';
        this.onFileDrop = new EventEmitter();
        this.onFileOver = new EventEmitter();
        this.onFileLeave = new EventEmitter();
        this.isDraggingOverDropZone = false;
        this.globalDraggingInProgress = false;
        this.files = [];
        this.numOfActiveReadEntries = 0;
        this.helperFormEl = null;
        this.fileInputPlaceholderEl = null;
        this.dropEventTimerSubscription = null;
        this._disabled = false;
        this.globalDragStartListener = this.renderer.listen('document', 'dragstart', function (evt) {
            _this.globalDraggingInProgress = true;
        });
        this.globalDragEndListener = this.renderer.listen('document', 'dragend', function (evt) {
            _this.globalDraggingInProgress = false;
        });
    }
    Object.defineProperty(FileComponent.prototype, "headertext", {
        /** @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead.
         * @return {?}
         */
        function () { return this.dropZoneLabel; },
        /** @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.dropZoneLabel = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "customstyle", {
        /** @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead.
         * @return {?}
         */
        function () { return this.dropZoneClassName; },
        /** @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.dropZoneClassName = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "customContentStyle", {
        /** @deprecated Will be removed in the next major version. Use `contentClassName` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `contentClassName` instead.
         * @return {?}
         */
        function () { return this.contentClassName; },
        /** @deprecated Will be removed in the next major version. Use `contentClassName` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `contentClassName` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.contentClassName = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "disabled", {
        get: /**
         * @return {?}
         */
        function () { return this._disabled; },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._disabled = (value != null && "" + value !== 'false');
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "disableIf", {
        /** @deprecated Will be removed in the next major version. Use `disabled` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `disabled` instead.
         * @return {?}
         */
        function () { return this.disabled; },
        /** @deprecated Will be removed in the next major version. Use `disabled` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `disabled` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.disabled = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "customBtnStyling", {
        /** @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead.
         * @return {?}
         */
        function () { return this.browseBtnClassName; },
        /** @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.browseBtnClassName = value;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    FileComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        if (this.dropEventTimerSubscription) {
            this.dropEventTimerSubscription.unsubscribe();
            this.dropEventTimerSubscription = null;
        }
        this.globalDragStartListener();
        this.globalDragEndListener();
        this.files = [];
        this.helperFormEl = null;
        this.fileInputPlaceholderEl = null;
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.onDragOver = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (!this.isDropzoneDisabled()) {
            if (!this.isDraggingOverDropZone) {
                this.isDraggingOverDropZone = true;
                this.onFileOver.emit(event);
            }
            this.preventAndStop(event);
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.onDragLeave = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (!this.isDropzoneDisabled()) {
            if (this.isDraggingOverDropZone) {
                this.isDraggingOverDropZone = false;
                this.onFileLeave.emit(event);
            }
            this.preventAndStop(event);
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.dropFiles = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (!this.isDropzoneDisabled()) {
            this.isDraggingOverDropZone = false;
            if (event.dataTransfer) {
                event.dataTransfer.dropEffect = 'copy';
                /** @type {?} */
                var items = void 0;
                if (event.dataTransfer.items) {
                    items = event.dataTransfer.items;
                }
                else {
                    items = event.dataTransfer.files;
                }
                this.preventAndStop(event);
                this.checkFiles(items);
            }
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.onBrowseButtonClick = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (this.fileSelector && this.fileSelector.nativeElement) {
            ((/** @type {?} */ (this.fileSelector.nativeElement))).click();
        }
    };
    /**
     * Processes the change event of the file input and adds the given files.
     * @param Event event
     */
    /**
     * Processes the change event of the file input and adds the given files.
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.uploadFiles = /**
     * Processes the change event of the file input and adds the given files.
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (!this.isDropzoneDisabled()) {
            if (event.target) {
                /** @type {?} */
                var items = ((/** @type {?} */ (event.target))).files || ((/** @type {?} */ ([])));
                this.checkFiles(items);
                this.resetFileInput();
            }
        }
    };
    /**
     * @param {?} items
     * @return {?}
     */
    FileComponent.prototype.checkFiles = /**
     * @param {?} items
     * @return {?}
     */
    function (items) {
        var _this = this;
        var _loop_1 = function (i) {
            /** @type {?} */
            var item = items[i];
            /** @type {?} */
            var entry = null;
            if (this_1.canGetAsEntry(item)) {
                entry = item.webkitGetAsEntry();
            }
            if (!entry) {
                if (item) {
                    /** @type {?} */
                    var fakeFileEntry = {
                        name: ((/** @type {?} */ (item))).name,
                        isDirectory: false,
                        isFile: true,
                        file: function (callback) {
                            callback((/** @type {?} */ (item)));
                        },
                    };
                    /** @type {?} */
                    var toUpload = new UploadFile(fakeFileEntry.name, fakeFileEntry);
                    this_1.addToQueue(toUpload);
                }
            }
            else {
                if (entry.isFile) {
                    /** @type {?} */
                    var toUpload = new UploadFile(entry.name, entry);
                    this_1.addToQueue(toUpload);
                }
                else if (entry.isDirectory) {
                    this_1.traverseFileTree(entry, entry.name);
                }
            }
        };
        var this_1 = this;
        for (var i = 0; i < items.length; i++) {
            _loop_1(i);
        }
        if (this.dropEventTimerSubscription) {
            this.dropEventTimerSubscription.unsubscribe();
        }
        this.dropEventTimerSubscription = timer(200, 200)
            .subscribe(function () {
            if (_this.files.length > 0 && _this.numOfActiveReadEntries === 0) {
                _this.onFileDrop.emit(new UploadEvent(_this.files));
                _this.files = [];
            }
        });
    };
    /**
     * @param {?} item
     * @param {?} path
     * @return {?}
     */
    FileComponent.prototype.traverseFileTree = /**
     * @param {?} item
     * @param {?} path
     * @return {?}
     */
    function (item, path) {
        var _this = this;
        if (item.isFile) {
            /** @type {?} */
            var toUpload = new UploadFile(path, item);
            this.files.push(toUpload);
        }
        else {
            path = path + '/';
            /** @type {?} */
            var dirReader_1 = ((/** @type {?} */ (item))).createReader();
            /** @type {?} */
            var entries_1 = [];
            /** @type {?} */
            var readEntries_1 = function () {
                _this.numOfActiveReadEntries++;
                dirReader_1.readEntries(function (result) {
                    if (!result.length) {
                        // add empty folders
                        if (entries_1.length === 0) {
                            /** @type {?} */
                            var toUpload_1 = new UploadFile(path, item);
                            _this.zone.run(function () {
                                _this.addToQueue(toUpload_1);
                            });
                        }
                        else {
                            var _loop_2 = function (i) {
                                _this.zone.run(function () {
                                    _this.traverseFileTree(entries_1[i], path + entries_1[i].name);
                                });
                            };
                            for (var i = 0; i < entries_1.length; i++) {
                                _loop_2(i);
                            }
                        }
                    }
                    else {
                        // continue with the reading
                        entries_1 = entries_1.concat(result);
                        readEntries_1();
                    }
                    _this.numOfActiveReadEntries--;
                });
            };
            readEntries_1();
        }
    };
    /**
     * Clears any added files from the file input element so the same file can subsequently be added multiple times.
     */
    /**
     * Clears any added files from the file input element so the same file can subsequently be added multiple times.
     * @return {?}
     */
    FileComponent.prototype.resetFileInput = /**
     * Clears any added files from the file input element so the same file can subsequently be added multiple times.
     * @return {?}
     */
    function () {
        if (this.fileSelector && this.fileSelector.nativeElement) {
            /** @type {?} */
            var fileInputEl = (/** @type {?} */ (this.fileSelector.nativeElement));
            /** @type {?} */
            var fileInputContainerEl = fileInputEl.parentElement;
            /** @type {?} */
            var helperFormEl = this.getHelperFormElement();
            /** @type {?} */
            var fileInputPlaceholderEl = this.getFileInputPlaceholderElement();
            // Just a quick check so we do not mess up the DOM (will never happen though).
            if (fileInputContainerEl !== helperFormEl) {
                // Insert the form input placeholder in the DOM before the form input element.
                this.renderer.insertBefore(fileInputContainerEl, fileInputPlaceholderEl, fileInputEl);
                // Add the form input as child of the temporary form element, removing the form input from the DOM.
                this.renderer.appendChild(helperFormEl, fileInputEl);
                // Reset the form, thus clearing the input element of any files.
                helperFormEl.reset();
                // Add the file input back to the DOM in place of the file input placeholder element.
                this.renderer.insertBefore(fileInputContainerEl, fileInputEl, fileInputPlaceholderEl);
                // Remove the input placeholder from the DOM
                this.renderer.removeChild(fileInputContainerEl, fileInputPlaceholderEl);
            }
        }
    };
    /**
     * Get a cached HTML form element as a helper element to clear the file input element.
     */
    /**
     * Get a cached HTML form element as a helper element to clear the file input element.
     * @return {?}
     */
    FileComponent.prototype.getHelperFormElement = /**
     * Get a cached HTML form element as a helper element to clear the file input element.
     * @return {?}
     */
    function () {
        if (!this.helperFormEl) {
            this.helperFormEl = (/** @type {?} */ (this.renderer.createElement('form')));
        }
        return this.helperFormEl;
    };
    /**
     * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
     */
    /**
     * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
     * @return {?}
     */
    FileComponent.prototype.getFileInputPlaceholderElement = /**
     * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
     * @return {?}
     */
    function () {
        if (!this.fileInputPlaceholderEl) {
            this.fileInputPlaceholderEl = (/** @type {?} */ (this.renderer.createElement('div')));
        }
        return this.fileInputPlaceholderEl;
    };
    /**
     * @param {?} item
     * @return {?}
     */
    FileComponent.prototype.canGetAsEntry = /**
     * @param {?} item
     * @return {?}
     */
    function (item) {
        return !!item.webkitGetAsEntry;
    };
    /**
     * @return {?}
     */
    FileComponent.prototype.isDropzoneDisabled = /**
     * @return {?}
     */
    function () {
        return (this.globalDraggingInProgress || this.disabled);
    };
    /**
     * @param {?} item
     * @return {?}
     */
    FileComponent.prototype.addToQueue = /**
     * @param {?} item
     * @return {?}
     */
    function (item) {
        this.files.push(item);
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.preventAndStop = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        event.stopPropagation();
        event.preventDefault();
    };
    FileComponent.decorators = [
        { type: Component, args: [{
                    selector: 'file-drop',
                    template: "<div [className]=\"dropZoneClassName\"\r\n     [class.over]=\"isDraggingOverDropZone\"\r\n     [class.ngx-file-drop__drop-zone--over]=\"isDraggingOverDropZone\"\r\n     (drop)=\"dropFiles($event)\"\r\n     (dragover)=\"onDragOver($event)\"\r\n     (dragleave)=\"onDragLeave($event)\">\r\n    <div [className]=\"contentClassName\">\r\n        <ng-content></ng-content>\r\n        <div *ngIf=\"dropZoneLabel\" class=\"ngx-file-drop__drop-zone-label\">{{dropZoneLabel}}</div>\r\n        <div *ngIf=\"showBrowseBtn\">\r\n            <input type=\"file\" #fileSelector [accept]=\"accept\" (change)=\"uploadFiles($event)\" multiple class=\"ngx-file-drop__file-input\" />\r\n            <input type=\"button\" [className]=\"browseBtnClassName\" value=\"{{browseBtnLabel}}\" (click)=\"onBrowseButtonClick($event)\" />\r\n        </div>\r\n    </div>\r\n</div>\r\n",
                    styles: [".drop-zone{height:100px;margin:auto;border:2px dotted #0782d0;border-radius:30px}.over{background-color:rgba(147,147,147,.5)}.content{display:flex;align-items:center;justify-content:center;height:100px;color:#0782d0}.ngx-file-drop__drop-zone-label{text-align:center}.ngx-file-drop__file-input{display:none}"]
                }] }
    ];
    /** @nocollapse */
    FileComponent.ctorParameters = function () { return [
        { type: NgZone },
        { type: Renderer2 }
    ]; };
    FileComponent.propDecorators = {
        accept: [{ type: Input }],
        dropZoneLabel: [{ type: Input }],
        headertext: [{ type: Input }],
        dropZoneClassName: [{ type: Input }],
        customstyle: [{ type: Input }],
        contentClassName: [{ type: Input }],
        customContentStyle: [{ type: Input }],
        disabled: [{ type: Input }],
        disableIf: [{ type: Input }],
        showBrowseBtn: [{ type: Input }],
        browseBtnClassName: [{ type: Input }],
        customBtnStyling: [{ type: Input }],
        browseBtnLabel: [{ type: Input }],
        onFileDrop: [{ type: Output }],
        onFileOver: [{ type: Output }],
        onFileLeave: [{ type: Output }],
        fileSelector: [{ type: ViewChild, args: ['fileSelector',] }]
    };
    return FileComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
var FileDropModule = /** @class */ (function () {
    function FileDropModule() {
    }
    FileDropModule.decorators = [
        { type: NgModule, args: [{
                    declarations: [
                        FileComponent,
                    ],
                    exports: [FileComponent],
                    imports: [CommonModule],
                    providers: [],
                    bootstrap: [FileComponent],
                },] }
    ];
    return FileDropModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */

export { FileComponent, FileDropModule, UploadFile, UploadEvent };

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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