/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
import { Component, Input, Output, EventEmitter, NgZone, Renderer2, ViewChild, ElementRef } from '@angular/core';
import { timer } from 'rxjs';
import { UploadFile } from './upload-file.model';
import { UploadEvent } from './upload-event.model';
var FileComponent = /** @class */ (function () {
    function FileComponent(zone, renderer) {
        var _this = this;
        this.zone = zone;
        this.renderer = renderer;
        this.accept = '*';
        this.dropZoneLabel = '';
        this.dropZoneClassName = 'ngx-file-drop__drop-zone drop-zone';
        this.contentClassName = 'ngx-file-drop__content content';
        this.showBrowseBtn = false;
        this.browseBtnClassName = 'btn btn-primary btn-xs ngx-file-drop__browse-btn';
        this.browseBtnLabel = 'Browse files';
        this.onFileDrop = new EventEmitter();
        this.onFileOver = new EventEmitter();
        this.onFileLeave = new EventEmitter();
        this.isDraggingOverDropZone = false;
        this.globalDraggingInProgress = false;
        this.files = [];
        this.numOfActiveReadEntries = 0;
        this.helperFormEl = null;
        this.fileInputPlaceholderEl = null;
        this.dropEventTimerSubscription = null;
        this._disabled = false;
        this.globalDragStartListener = this.renderer.listen('document', 'dragstart', function (evt) {
            _this.globalDraggingInProgress = true;
        });
        this.globalDragEndListener = this.renderer.listen('document', 'dragend', function (evt) {
            _this.globalDraggingInProgress = false;
        });
    }
    Object.defineProperty(FileComponent.prototype, "headertext", {
        /** @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead.
         * @return {?}
         */
        function () { return this.dropZoneLabel; },
        /** @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.dropZoneLabel = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "customstyle", {
        /** @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead.
         * @return {?}
         */
        function () { return this.dropZoneClassName; },
        /** @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.dropZoneClassName = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "customContentStyle", {
        /** @deprecated Will be removed in the next major version. Use `contentClassName` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `contentClassName` instead.
         * @return {?}
         */
        function () { return this.contentClassName; },
        /** @deprecated Will be removed in the next major version. Use `contentClassName` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `contentClassName` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.contentClassName = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "disabled", {
        get: /**
         * @return {?}
         */
        function () { return this._disabled; },
        set: /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this._disabled = (value != null && "" + value !== 'false');
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "disableIf", {
        /** @deprecated Will be removed in the next major version. Use `disabled` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `disabled` instead.
         * @return {?}
         */
        function () { return this.disabled; },
        /** @deprecated Will be removed in the next major version. Use `disabled` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `disabled` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.disabled = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FileComponent.prototype, "customBtnStyling", {
        /** @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead. */
        get: /**
         * @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead.
         * @return {?}
         */
        function () { return this.browseBtnClassName; },
        /** @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead. */
        set: /**
         * @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead.
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.browseBtnClassName = value;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    FileComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        if (this.dropEventTimerSubscription) {
            this.dropEventTimerSubscription.unsubscribe();
            this.dropEventTimerSubscription = null;
        }
        this.globalDragStartListener();
        this.globalDragEndListener();
        this.files = [];
        this.helperFormEl = null;
        this.fileInputPlaceholderEl = null;
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.onDragOver = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (!this.isDropzoneDisabled()) {
            if (!this.isDraggingOverDropZone) {
                this.isDraggingOverDropZone = true;
                this.onFileOver.emit(event);
            }
            this.preventAndStop(event);
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.onDragLeave = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (!this.isDropzoneDisabled()) {
            if (this.isDraggingOverDropZone) {
                this.isDraggingOverDropZone = false;
                this.onFileLeave.emit(event);
            }
            this.preventAndStop(event);
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.dropFiles = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (!this.isDropzoneDisabled()) {
            this.isDraggingOverDropZone = false;
            if (event.dataTransfer) {
                event.dataTransfer.dropEffect = 'copy';
                /** @type {?} */
                var items = void 0;
                if (event.dataTransfer.items) {
                    items = event.dataTransfer.items;
                }
                else {
                    items = event.dataTransfer.files;
                }
                this.preventAndStop(event);
                this.checkFiles(items);
            }
        }
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.onBrowseButtonClick = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (this.fileSelector && this.fileSelector.nativeElement) {
            ((/** @type {?} */ (this.fileSelector.nativeElement))).click();
        }
    };
    /**
     * Processes the change event of the file input and adds the given files.
     * @param Event event
     */
    /**
     * Processes the change event of the file input and adds the given files.
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.uploadFiles = /**
     * Processes the change event of the file input and adds the given files.
     * @param {?} event
     * @return {?}
     */
    function (event) {
        if (!this.isDropzoneDisabled()) {
            if (event.target) {
                /** @type {?} */
                var items = ((/** @type {?} */ (event.target))).files || ((/** @type {?} */ ([])));
                this.checkFiles(items);
                this.resetFileInput();
            }
        }
    };
    /**
     * @param {?} items
     * @return {?}
     */
    FileComponent.prototype.checkFiles = /**
     * @param {?} items
     * @return {?}
     */
    function (items) {
        var _this = this;
        var _loop_1 = function (i) {
            /** @type {?} */
            var item = items[i];
            /** @type {?} */
            var entry = null;
            if (this_1.canGetAsEntry(item)) {
                entry = item.webkitGetAsEntry();
            }
            if (!entry) {
                if (item) {
                    /** @type {?} */
                    var fakeFileEntry = {
                        name: ((/** @type {?} */ (item))).name,
                        isDirectory: false,
                        isFile: true,
                        file: function (callback) {
                            callback((/** @type {?} */ (item)));
                        },
                    };
                    /** @type {?} */
                    var toUpload = new UploadFile(fakeFileEntry.name, fakeFileEntry);
                    this_1.addToQueue(toUpload);
                }
            }
            else {
                if (entry.isFile) {
                    /** @type {?} */
                    var toUpload = new UploadFile(entry.name, entry);
                    this_1.addToQueue(toUpload);
                }
                else if (entry.isDirectory) {
                    this_1.traverseFileTree(entry, entry.name);
                }
            }
        };
        var this_1 = this;
        for (var i = 0; i < items.length; i++) {
            _loop_1(i);
        }
        if (this.dropEventTimerSubscription) {
            this.dropEventTimerSubscription.unsubscribe();
        }
        this.dropEventTimerSubscription = timer(200, 200)
            .subscribe(function () {
            if (_this.files.length > 0 && _this.numOfActiveReadEntries === 0) {
                _this.onFileDrop.emit(new UploadEvent(_this.files));
                _this.files = [];
            }
        });
    };
    /**
     * @param {?} item
     * @param {?} path
     * @return {?}
     */
    FileComponent.prototype.traverseFileTree = /**
     * @param {?} item
     * @param {?} path
     * @return {?}
     */
    function (item, path) {
        var _this = this;
        if (item.isFile) {
            /** @type {?} */
            var toUpload = new UploadFile(path, item);
            this.files.push(toUpload);
        }
        else {
            path = path + '/';
            /** @type {?} */
            var dirReader_1 = ((/** @type {?} */ (item))).createReader();
            /** @type {?} */
            var entries_1 = [];
            /** @type {?} */
            var readEntries_1 = function () {
                _this.numOfActiveReadEntries++;
                dirReader_1.readEntries(function (result) {
                    if (!result.length) {
                        // add empty folders
                        if (entries_1.length === 0) {
                            /** @type {?} */
                            var toUpload_1 = new UploadFile(path, item);
                            _this.zone.run(function () {
                                _this.addToQueue(toUpload_1);
                            });
                        }
                        else {
                            var _loop_2 = function (i) {
                                _this.zone.run(function () {
                                    _this.traverseFileTree(entries_1[i], path + entries_1[i].name);
                                });
                            };
                            for (var i = 0; i < entries_1.length; i++) {
                                _loop_2(i);
                            }
                        }
                    }
                    else {
                        // continue with the reading
                        entries_1 = entries_1.concat(result);
                        readEntries_1();
                    }
                    _this.numOfActiveReadEntries--;
                });
            };
            readEntries_1();
        }
    };
    /**
     * Clears any added files from the file input element so the same file can subsequently be added multiple times.
     */
    /**
     * Clears any added files from the file input element so the same file can subsequently be added multiple times.
     * @return {?}
     */
    FileComponent.prototype.resetFileInput = /**
     * Clears any added files from the file input element so the same file can subsequently be added multiple times.
     * @return {?}
     */
    function () {
        if (this.fileSelector && this.fileSelector.nativeElement) {
            /** @type {?} */
            var fileInputEl = (/** @type {?} */ (this.fileSelector.nativeElement));
            /** @type {?} */
            var fileInputContainerEl = fileInputEl.parentElement;
            /** @type {?} */
            var helperFormEl = this.getHelperFormElement();
            /** @type {?} */
            var fileInputPlaceholderEl = this.getFileInputPlaceholderElement();
            // Just a quick check so we do not mess up the DOM (will never happen though).
            if (fileInputContainerEl !== helperFormEl) {
                // Insert the form input placeholder in the DOM before the form input element.
                this.renderer.insertBefore(fileInputContainerEl, fileInputPlaceholderEl, fileInputEl);
                // Add the form input as child of the temporary form element, removing the form input from the DOM.
                this.renderer.appendChild(helperFormEl, fileInputEl);
                // Reset the form, thus clearing the input element of any files.
                helperFormEl.reset();
                // Add the file input back to the DOM in place of the file input placeholder element.
                this.renderer.insertBefore(fileInputContainerEl, fileInputEl, fileInputPlaceholderEl);
                // Remove the input placeholder from the DOM
                this.renderer.removeChild(fileInputContainerEl, fileInputPlaceholderEl);
            }
        }
    };
    /**
     * Get a cached HTML form element as a helper element to clear the file input element.
     */
    /**
     * Get a cached HTML form element as a helper element to clear the file input element.
     * @return {?}
     */
    FileComponent.prototype.getHelperFormElement = /**
     * Get a cached HTML form element as a helper element to clear the file input element.
     * @return {?}
     */
    function () {
        if (!this.helperFormEl) {
            this.helperFormEl = (/** @type {?} */ (this.renderer.createElement('form')));
        }
        return this.helperFormEl;
    };
    /**
     * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
     */
    /**
     * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
     * @return {?}
     */
    FileComponent.prototype.getFileInputPlaceholderElement = /**
     * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
     * @return {?}
     */
    function () {
        if (!this.fileInputPlaceholderEl) {
            this.fileInputPlaceholderEl = (/** @type {?} */ (this.renderer.createElement('div')));
        }
        return this.fileInputPlaceholderEl;
    };
    /**
     * @param {?} item
     * @return {?}
     */
    FileComponent.prototype.canGetAsEntry = /**
     * @param {?} item
     * @return {?}
     */
    function (item) {
        return !!item.webkitGetAsEntry;
    };
    /**
     * @return {?}
     */
    FileComponent.prototype.isDropzoneDisabled = /**
     * @return {?}
     */
    function () {
        return (this.globalDraggingInProgress || this.disabled);
    };
    /**
     * @param {?} item
     * @return {?}
     */
    FileComponent.prototype.addToQueue = /**
     * @param {?} item
     * @return {?}
     */
    function (item) {
        this.files.push(item);
    };
    /**
     * @param {?} event
     * @return {?}
     */
    FileComponent.prototype.preventAndStop = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        event.stopPropagation();
        event.preventDefault();
    };
    FileComponent.decorators = [
        { type: Component, args: [{
                    selector: 'file-drop',
                    template: "<div [className]=\"dropZoneClassName\"\r\n     [class.over]=\"isDraggingOverDropZone\"\r\n     [class.ngx-file-drop__drop-zone--over]=\"isDraggingOverDropZone\"\r\n     (drop)=\"dropFiles($event)\"\r\n     (dragover)=\"onDragOver($event)\"\r\n     (dragleave)=\"onDragLeave($event)\">\r\n    <div [className]=\"contentClassName\">\r\n        <ng-content></ng-content>\r\n        <div *ngIf=\"dropZoneLabel\" class=\"ngx-file-drop__drop-zone-label\">{{dropZoneLabel}}</div>\r\n        <div *ngIf=\"showBrowseBtn\">\r\n            <input type=\"file\" #fileSelector [accept]=\"accept\" (change)=\"uploadFiles($event)\" multiple class=\"ngx-file-drop__file-input\" />\r\n            <input type=\"button\" [className]=\"browseBtnClassName\" value=\"{{browseBtnLabel}}\" (click)=\"onBrowseButtonClick($event)\" />\r\n        </div>\r\n    </div>\r\n</div>\r\n",
                    styles: [".drop-zone{height:100px;margin:auto;border:2px dotted #0782d0;border-radius:30px}.over{background-color:rgba(147,147,147,.5)}.content{display:flex;align-items:center;justify-content:center;height:100px;color:#0782d0}.ngx-file-drop__drop-zone-label{text-align:center}.ngx-file-drop__file-input{display:none}"]
                }] }
    ];
    /** @nocollapse */
    FileComponent.ctorParameters = function () { return [
        { type: NgZone },
        { type: Renderer2 }
    ]; };
    FileComponent.propDecorators = {
        accept: [{ type: Input }],
        dropZoneLabel: [{ type: Input }],
        headertext: [{ type: Input }],
        dropZoneClassName: [{ type: Input }],
        customstyle: [{ type: Input }],
        contentClassName: [{ type: Input }],
        customContentStyle: [{ type: Input }],
        disabled: [{ type: Input }],
        disableIf: [{ type: Input }],
        showBrowseBtn: [{ type: Input }],
        browseBtnClassName: [{ type: Input }],
        customBtnStyling: [{ type: Input }],
        browseBtnLabel: [{ type: Input }],
        onFileDrop: [{ type: Output }],
        onFileOver: [{ type: Output }],
        onFileLeave: [{ type: Output }],
        fileSelector: [{ type: ViewChild, args: ['fileSelector',] }]
    };
    return FileComponent;
}());
export { FileComponent };
if (false) {
    /** @type {?} */
    FileComponent.prototype.accept;
    /** @type {?} */
    FileComponent.prototype.dropZoneLabel;
    /** @type {?} */
    FileComponent.prototype.dropZoneClassName;
    /** @type {?} */
    FileComponent.prototype.contentClassName;
    /** @type {?} */
    FileComponent.prototype.showBrowseBtn;
    /** @type {?} */
    FileComponent.prototype.browseBtnClassName;
    /** @type {?} */
    FileComponent.prototype.browseBtnLabel;
    /** @type {?} */
    FileComponent.prototype.onFileDrop;
    /** @type {?} */
    FileComponent.prototype.onFileOver;
    /** @type {?} */
    FileComponent.prototype.onFileLeave;
    /** @type {?} */
    FileComponent.prototype.fileSelector;
    /** @type {?} */
    FileComponent.prototype.isDraggingOverDropZone;
    /** @type {?} */
    FileComponent.prototype.globalDraggingInProgress;
    /** @type {?} */
    FileComponent.prototype.globalDragStartListener;
    /** @type {?} */
    FileComponent.prototype.globalDragEndListener;
    /** @type {?} */
    FileComponent.prototype.files;
    /** @type {?} */
    FileComponent.prototype.numOfActiveReadEntries;
    /** @type {?} */
    FileComponent.prototype.helperFormEl;
    /** @type {?} */
    FileComponent.prototype.fileInputPlaceholderEl;
    /** @type {?} */
    FileComponent.prototype.dropEventTimerSubscription;
    /** @type {?} */
    FileComponent.prototype._disabled;
    /** @type {?} */
    FileComponent.prototype.zone;
    /** @type {?} */
    FileComponent.prototype.renderer;
}
//# sourceMappingURL=data:application/json;base64,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