/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
import { Component, Input, Output, EventEmitter, NgZone, Renderer2, ViewChild, ElementRef } from '@angular/core';
import { timer } from 'rxjs';
import { UploadFile } from './upload-file.model';
import { UploadEvent } from './upload-event.model';
export class FileComponent {
    /**
     * @param {?} zone
     * @param {?} renderer
     */
    constructor(zone, renderer) {
        this.zone = zone;
        this.renderer = renderer;
        this.accept = '*';
        this.dropZoneLabel = '';
        this.dropZoneClassName = 'ngx-file-drop__drop-zone drop-zone';
        this.contentClassName = 'ngx-file-drop__content content';
        this.showBrowseBtn = false;
        this.browseBtnClassName = 'btn btn-primary btn-xs ngx-file-drop__browse-btn';
        this.browseBtnLabel = 'Browse files';
        this.onFileDrop = new EventEmitter();
        this.onFileOver = new EventEmitter();
        this.onFileLeave = new EventEmitter();
        this.isDraggingOverDropZone = false;
        this.globalDraggingInProgress = false;
        this.files = [];
        this.numOfActiveReadEntries = 0;
        this.helperFormEl = null;
        this.fileInputPlaceholderEl = null;
        this.dropEventTimerSubscription = null;
        this._disabled = false;
        this.globalDragStartListener = this.renderer.listen('document', 'dragstart', (evt) => {
            this.globalDraggingInProgress = true;
        });
        this.globalDragEndListener = this.renderer.listen('document', 'dragend', (evt) => {
            this.globalDraggingInProgress = false;
        });
    }
    /**
     * @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead.
     * @return {?}
     */
    get headertext() { return this.dropZoneLabel; }
    /**
     * @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead.
     * @param {?} value
     * @return {?}
     */
    set headertext(value) {
        this.dropZoneLabel = value;
    }
    /**
     * @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead.
     * @return {?}
     */
    get customstyle() { return this.dropZoneClassName; }
    /**
     * @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead.
     * @param {?} value
     * @return {?}
     */
    set customstyle(value) {
        this.dropZoneClassName = value;
    }
    /**
     * @deprecated Will be removed in the next major version. Use `contentClassName` instead.
     * @return {?}
     */
    get customContentStyle() { return this.contentClassName; }
    /**
     * @deprecated Will be removed in the next major version. Use `contentClassName` instead.
     * @param {?} value
     * @return {?}
     */
    set customContentStyle(value) {
        this.contentClassName = value;
    }
    /**
     * @return {?}
     */
    get disabled() { return this._disabled; }
    /**
     * @param {?} value
     * @return {?}
     */
    set disabled(value) {
        this._disabled = (value != null && `${value}` !== 'false');
    }
    /**
     * @deprecated Will be removed in the next major version. Use `disabled` instead.
     * @return {?}
     */
    get disableIf() { return this.disabled; }
    /**
     * @deprecated Will be removed in the next major version. Use `disabled` instead.
     * @param {?} value
     * @return {?}
     */
    set disableIf(value) {
        this.disabled = value;
    }
    /**
     * @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead.
     * @return {?}
     */
    get customBtnStyling() { return this.browseBtnClassName; }
    /**
     * @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead.
     * @param {?} value
     * @return {?}
     */
    set customBtnStyling(value) {
        this.browseBtnClassName = value;
    }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        if (this.dropEventTimerSubscription) {
            this.dropEventTimerSubscription.unsubscribe();
            this.dropEventTimerSubscription = null;
        }
        this.globalDragStartListener();
        this.globalDragEndListener();
        this.files = [];
        this.helperFormEl = null;
        this.fileInputPlaceholderEl = null;
    }
    /**
     * @param {?} event
     * @return {?}
     */
    onDragOver(event) {
        if (!this.isDropzoneDisabled()) {
            if (!this.isDraggingOverDropZone) {
                this.isDraggingOverDropZone = true;
                this.onFileOver.emit(event);
            }
            this.preventAndStop(event);
        }
    }
    /**
     * @param {?} event
     * @return {?}
     */
    onDragLeave(event) {
        if (!this.isDropzoneDisabled()) {
            if (this.isDraggingOverDropZone) {
                this.isDraggingOverDropZone = false;
                this.onFileLeave.emit(event);
            }
            this.preventAndStop(event);
        }
    }
    /**
     * @param {?} event
     * @return {?}
     */
    dropFiles(event) {
        if (!this.isDropzoneDisabled()) {
            this.isDraggingOverDropZone = false;
            if (event.dataTransfer) {
                event.dataTransfer.dropEffect = 'copy';
                /** @type {?} */
                let items;
                if (event.dataTransfer.items) {
                    items = event.dataTransfer.items;
                }
                else {
                    items = event.dataTransfer.files;
                }
                this.preventAndStop(event);
                this.checkFiles(items);
            }
        }
    }
    /**
     * @param {?} event
     * @return {?}
     */
    onBrowseButtonClick(event) {
        if (this.fileSelector && this.fileSelector.nativeElement) {
            ((/** @type {?} */ (this.fileSelector.nativeElement))).click();
        }
    }
    /**
     * Processes the change event of the file input and adds the given files.
     * @param {?} event
     * @return {?}
     */
    uploadFiles(event) {
        if (!this.isDropzoneDisabled()) {
            if (event.target) {
                /** @type {?} */
                const items = ((/** @type {?} */ (event.target))).files || ((/** @type {?} */ ([])));
                this.checkFiles(items);
                this.resetFileInput();
            }
        }
    }
    /**
     * @param {?} items
     * @return {?}
     */
    checkFiles(items) {
        for (let i = 0; i < items.length; i++) {
            /** @type {?} */
            const item = items[i];
            /** @type {?} */
            let entry = null;
            if (this.canGetAsEntry(item)) {
                entry = item.webkitGetAsEntry();
            }
            if (!entry) {
                if (item) {
                    /** @type {?} */
                    const fakeFileEntry = {
                        name: ((/** @type {?} */ (item))).name,
                        isDirectory: false,
                        isFile: true,
                        file: (callback) => {
                            callback((/** @type {?} */ (item)));
                        },
                    };
                    /** @type {?} */
                    const toUpload = new UploadFile(fakeFileEntry.name, fakeFileEntry);
                    this.addToQueue(toUpload);
                }
            }
            else {
                if (entry.isFile) {
                    /** @type {?} */
                    const toUpload = new UploadFile(entry.name, entry);
                    this.addToQueue(toUpload);
                }
                else if (entry.isDirectory) {
                    this.traverseFileTree(entry, entry.name);
                }
            }
        }
        if (this.dropEventTimerSubscription) {
            this.dropEventTimerSubscription.unsubscribe();
        }
        this.dropEventTimerSubscription = timer(200, 200)
            .subscribe(() => {
            if (this.files.length > 0 && this.numOfActiveReadEntries === 0) {
                this.onFileDrop.emit(new UploadEvent(this.files));
                this.files = [];
            }
        });
    }
    /**
     * @param {?} item
     * @param {?} path
     * @return {?}
     */
    traverseFileTree(item, path) {
        if (item.isFile) {
            /** @type {?} */
            const toUpload = new UploadFile(path, item);
            this.files.push(toUpload);
        }
        else {
            path = path + '/';
            /** @type {?} */
            const dirReader = ((/** @type {?} */ (item))).createReader();
            /** @type {?} */
            let entries = [];
            /** @type {?} */
            const readEntries = () => {
                this.numOfActiveReadEntries++;
                dirReader.readEntries((result) => {
                    if (!result.length) {
                        // add empty folders
                        if (entries.length === 0) {
                            /** @type {?} */
                            const toUpload = new UploadFile(path, item);
                            this.zone.run(() => {
                                this.addToQueue(toUpload);
                            });
                        }
                        else {
                            for (let i = 0; i < entries.length; i++) {
                                this.zone.run(() => {
                                    this.traverseFileTree(entries[i], path + entries[i].name);
                                });
                            }
                        }
                    }
                    else {
                        // continue with the reading
                        entries = entries.concat(result);
                        readEntries();
                    }
                    this.numOfActiveReadEntries--;
                });
            };
            readEntries();
        }
    }
    /**
     * Clears any added files from the file input element so the same file can subsequently be added multiple times.
     * @return {?}
     */
    resetFileInput() {
        if (this.fileSelector && this.fileSelector.nativeElement) {
            /** @type {?} */
            const fileInputEl = (/** @type {?} */ (this.fileSelector.nativeElement));
            /** @type {?} */
            const fileInputContainerEl = fileInputEl.parentElement;
            /** @type {?} */
            const helperFormEl = this.getHelperFormElement();
            /** @type {?} */
            const fileInputPlaceholderEl = this.getFileInputPlaceholderElement();
            // Just a quick check so we do not mess up the DOM (will never happen though).
            if (fileInputContainerEl !== helperFormEl) {
                // Insert the form input placeholder in the DOM before the form input element.
                this.renderer.insertBefore(fileInputContainerEl, fileInputPlaceholderEl, fileInputEl);
                // Add the form input as child of the temporary form element, removing the form input from the DOM.
                this.renderer.appendChild(helperFormEl, fileInputEl);
                // Reset the form, thus clearing the input element of any files.
                helperFormEl.reset();
                // Add the file input back to the DOM in place of the file input placeholder element.
                this.renderer.insertBefore(fileInputContainerEl, fileInputEl, fileInputPlaceholderEl);
                // Remove the input placeholder from the DOM
                this.renderer.removeChild(fileInputContainerEl, fileInputPlaceholderEl);
            }
        }
    }
    /**
     * Get a cached HTML form element as a helper element to clear the file input element.
     * @return {?}
     */
    getHelperFormElement() {
        if (!this.helperFormEl) {
            this.helperFormEl = (/** @type {?} */ (this.renderer.createElement('form')));
        }
        return this.helperFormEl;
    }
    /**
     * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
     * @return {?}
     */
    getFileInputPlaceholderElement() {
        if (!this.fileInputPlaceholderEl) {
            this.fileInputPlaceholderEl = (/** @type {?} */ (this.renderer.createElement('div')));
        }
        return this.fileInputPlaceholderEl;
    }
    /**
     * @param {?} item
     * @return {?}
     */
    canGetAsEntry(item) {
        return !!item.webkitGetAsEntry;
    }
    /**
     * @return {?}
     */
    isDropzoneDisabled() {
        return (this.globalDraggingInProgress || this.disabled);
    }
    /**
     * @param {?} item
     * @return {?}
     */
    addToQueue(item) {
        this.files.push(item);
    }
    /**
     * @param {?} event
     * @return {?}
     */
    preventAndStop(event) {
        event.stopPropagation();
        event.preventDefault();
    }
}
FileComponent.decorators = [
    { type: Component, args: [{
                selector: 'file-drop',
                template: "<div [className]=\"dropZoneClassName\"\r\n     [class.over]=\"isDraggingOverDropZone\"\r\n     [class.ngx-file-drop__drop-zone--over]=\"isDraggingOverDropZone\"\r\n     (drop)=\"dropFiles($event)\"\r\n     (dragover)=\"onDragOver($event)\"\r\n     (dragleave)=\"onDragLeave($event)\">\r\n    <div [className]=\"contentClassName\">\r\n        <ng-content></ng-content>\r\n        <div *ngIf=\"dropZoneLabel\" class=\"ngx-file-drop__drop-zone-label\">{{dropZoneLabel}}</div>\r\n        <div *ngIf=\"showBrowseBtn\">\r\n            <input type=\"file\" #fileSelector [accept]=\"accept\" (change)=\"uploadFiles($event)\" multiple class=\"ngx-file-drop__file-input\" />\r\n            <input type=\"button\" [className]=\"browseBtnClassName\" value=\"{{browseBtnLabel}}\" (click)=\"onBrowseButtonClick($event)\" />\r\n        </div>\r\n    </div>\r\n</div>\r\n",
                styles: [".drop-zone{height:100px;margin:auto;border:2px dotted #0782d0;border-radius:30px}.over{background-color:rgba(147,147,147,.5)}.content{display:flex;align-items:center;justify-content:center;height:100px;color:#0782d0}.ngx-file-drop__drop-zone-label{text-align:center}.ngx-file-drop__file-input{display:none}"]
            }] }
];
/** @nocollapse */
FileComponent.ctorParameters = () => [
    { type: NgZone },
    { type: Renderer2 }
];
FileComponent.propDecorators = {
    accept: [{ type: Input }],
    dropZoneLabel: [{ type: Input }],
    headertext: [{ type: Input }],
    dropZoneClassName: [{ type: Input }],
    customstyle: [{ type: Input }],
    contentClassName: [{ type: Input }],
    customContentStyle: [{ type: Input }],
    disabled: [{ type: Input }],
    disableIf: [{ type: Input }],
    showBrowseBtn: [{ type: Input }],
    browseBtnClassName: [{ type: Input }],
    customBtnStyling: [{ type: Input }],
    browseBtnLabel: [{ type: Input }],
    onFileDrop: [{ type: Output }],
    onFileOver: [{ type: Output }],
    onFileLeave: [{ type: Output }],
    fileSelector: [{ type: ViewChild, args: ['fileSelector',] }]
};
if (false) {
    /** @type {?} */
    FileComponent.prototype.accept;
    /** @type {?} */
    FileComponent.prototype.dropZoneLabel;
    /** @type {?} */
    FileComponent.prototype.dropZoneClassName;
    /** @type {?} */
    FileComponent.prototype.contentClassName;
    /** @type {?} */
    FileComponent.prototype.showBrowseBtn;
    /** @type {?} */
    FileComponent.prototype.browseBtnClassName;
    /** @type {?} */
    FileComponent.prototype.browseBtnLabel;
    /** @type {?} */
    FileComponent.prototype.onFileDrop;
    /** @type {?} */
    FileComponent.prototype.onFileOver;
    /** @type {?} */
    FileComponent.prototype.onFileLeave;
    /** @type {?} */
    FileComponent.prototype.fileSelector;
    /** @type {?} */
    FileComponent.prototype.isDraggingOverDropZone;
    /** @type {?} */
    FileComponent.prototype.globalDraggingInProgress;
    /** @type {?} */
    FileComponent.prototype.globalDragStartListener;
    /** @type {?} */
    FileComponent.prototype.globalDragEndListener;
    /** @type {?} */
    FileComponent.prototype.files;
    /** @type {?} */
    FileComponent.prototype.numOfActiveReadEntries;
    /** @type {?} */
    FileComponent.prototype.helperFormEl;
    /** @type {?} */
    FileComponent.prototype.fileInputPlaceholderEl;
    /** @type {?} */
    FileComponent.prototype.dropEventTimerSubscription;
    /** @type {?} */
    FileComponent.prototype._disabled;
    /** @type {?} */
    FileComponent.prototype.zone;
    /** @type {?} */
    FileComponent.prototype.renderer;
}
//# sourceMappingURL=data:application/json;base64,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