(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('rxjs'), require('@angular/common')) :
    typeof define === 'function' && define.amd ? define('ngx-file-drop', ['exports', '@angular/core', 'rxjs', '@angular/common'], factory) :
    (factory((global['ngx-file-drop'] = {}),global.ng.core,global.rxjs,global.ng.common));
}(this, (function (exports,core,rxjs,common) { 'use strict';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
     */
    /**
     * fileEntry is an instance of {\@link FileSystemFileEntry} or {\@link FileSystemDirectoryEntry}.
     * Which one is it can be checked using {\@link FileSystemEntry.isFile} or {\@link FileSystemEntry.isDirectory}
     * properties of the given {\@link FileSystemEntry}.
     */
    var /**
     * fileEntry is an instance of {\@link FileSystemFileEntry} or {\@link FileSystemDirectoryEntry}.
     * Which one is it can be checked using {\@link FileSystemEntry.isFile} or {\@link FileSystemEntry.isDirectory}
     * properties of the given {\@link FileSystemEntry}.
     */ UploadFile = /** @class */ (function () {
        function UploadFile(relativePath, fileEntry) {
            this.relativePath = relativePath;
            this.fileEntry = fileEntry;
        }
        return UploadFile;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
     */
    var UploadEvent = /** @class */ (function () {
        function UploadEvent(files) {
            this.files = files;
        }
        return UploadEvent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
     */
    var FileComponent = /** @class */ (function () {
        function FileComponent(zone, renderer) {
            var _this = this;
            this.zone = zone;
            this.renderer = renderer;
            this.accept = '*';
            this.dropZoneLabel = '';
            this.dropZoneClassName = 'ngx-file-drop__drop-zone drop-zone';
            this.contentClassName = 'ngx-file-drop__content content';
            this.showBrowseBtn = false;
            this.browseBtnClassName = 'btn btn-primary btn-xs ngx-file-drop__browse-btn';
            this.browseBtnLabel = 'Browse files';
            this.onFileDrop = new core.EventEmitter();
            this.onFileOver = new core.EventEmitter();
            this.onFileLeave = new core.EventEmitter();
            this.isDraggingOverDropZone = false;
            this.globalDraggingInProgress = false;
            this.files = [];
            this.numOfActiveReadEntries = 0;
            this.helperFormEl = null;
            this.fileInputPlaceholderEl = null;
            this.dropEventTimerSubscription = null;
            this._disabled = false;
            this.globalDragStartListener = this.renderer.listen('document', 'dragstart', function (evt) {
                _this.globalDraggingInProgress = true;
            });
            this.globalDragEndListener = this.renderer.listen('document', 'dragend', function (evt) {
                _this.globalDraggingInProgress = false;
            });
        }
        Object.defineProperty(FileComponent.prototype, "headertext", {
            /** @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead. */
            get: /**
             * @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead.
             * @return {?}
             */ function () { return this.dropZoneLabel; },
            /** @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead. */
            set: /**
             * @deprecated Will be removed in the next major version. Use `dropZoneLabel` instead.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.dropZoneLabel = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FileComponent.prototype, "customstyle", {
            /** @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead. */
            get: /**
             * @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead.
             * @return {?}
             */ function () { return this.dropZoneClassName; },
            /** @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead. */
            set: /**
             * @deprecated Will be removed in the next major version. Use `dropZoneClassName` instead.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.dropZoneClassName = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FileComponent.prototype, "customContentStyle", {
            /** @deprecated Will be removed in the next major version. Use `contentClassName` instead. */
            get: /**
             * @deprecated Will be removed in the next major version. Use `contentClassName` instead.
             * @return {?}
             */ function () { return this.contentClassName; },
            /** @deprecated Will be removed in the next major version. Use `contentClassName` instead. */
            set: /**
             * @deprecated Will be removed in the next major version. Use `contentClassName` instead.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.contentClassName = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FileComponent.prototype, "disabled", {
            get: /**
             * @return {?}
             */ function () { return this._disabled; },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = (value != null && "" + value !== 'false');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FileComponent.prototype, "disableIf", {
            /** @deprecated Will be removed in the next major version. Use `disabled` instead. */
            get: /**
             * @deprecated Will be removed in the next major version. Use `disabled` instead.
             * @return {?}
             */ function () { return this.disabled; },
            /** @deprecated Will be removed in the next major version. Use `disabled` instead. */
            set: /**
             * @deprecated Will be removed in the next major version. Use `disabled` instead.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.disabled = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FileComponent.prototype, "customBtnStyling", {
            /** @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead. */
            get: /**
             * @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead.
             * @return {?}
             */ function () { return this.browseBtnClassName; },
            /** @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead. */
            set: /**
             * @deprecated Will be removed in the next major version. Use `browseBtnClassName` instead.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.browseBtnClassName = value;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        FileComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                if (this.dropEventTimerSubscription) {
                    this.dropEventTimerSubscription.unsubscribe();
                    this.dropEventTimerSubscription = null;
                }
                this.globalDragStartListener();
                this.globalDragEndListener();
                this.files = [];
                this.helperFormEl = null;
                this.fileInputPlaceholderEl = null;
            };
        /**
         * @param {?} event
         * @return {?}
         */
        FileComponent.prototype.onDragOver = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (!this.isDropzoneDisabled()) {
                    if (!this.isDraggingOverDropZone) {
                        this.isDraggingOverDropZone = true;
                        this.onFileOver.emit(event);
                    }
                    this.preventAndStop(event);
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        FileComponent.prototype.onDragLeave = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (!this.isDropzoneDisabled()) {
                    if (this.isDraggingOverDropZone) {
                        this.isDraggingOverDropZone = false;
                        this.onFileLeave.emit(event);
                    }
                    this.preventAndStop(event);
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        FileComponent.prototype.dropFiles = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (!this.isDropzoneDisabled()) {
                    this.isDraggingOverDropZone = false;
                    if (event.dataTransfer) {
                        event.dataTransfer.dropEffect = 'copy';
                        /** @type {?} */
                        var items = void 0;
                        if (event.dataTransfer.items) {
                            items = event.dataTransfer.items;
                        }
                        else {
                            items = event.dataTransfer.files;
                        }
                        this.preventAndStop(event);
                        this.checkFiles(items);
                    }
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        FileComponent.prototype.onBrowseButtonClick = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (this.fileSelector && this.fileSelector.nativeElement) {
                    (( /** @type {?} */(this.fileSelector.nativeElement))).click();
                }
            };
        /**
         * Processes the change event of the file input and adds the given files.
         * @param Event event
         */
        /**
         * Processes the change event of the file input and adds the given files.
         * @param {?} event
         * @return {?}
         */
        FileComponent.prototype.uploadFiles = /**
         * Processes the change event of the file input and adds the given files.
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (!this.isDropzoneDisabled()) {
                    if (event.target) {
                        /** @type {?} */
                        var items = (( /** @type {?} */(event.target))).files || (( /** @type {?} */([])));
                        this.checkFiles(items);
                        this.resetFileInput();
                    }
                }
            };
        /**
         * @param {?} items
         * @return {?}
         */
        FileComponent.prototype.checkFiles = /**
         * @param {?} items
         * @return {?}
         */
            function (items) {
                var _this = this;
                var _loop_1 = function (i) {
                    /** @type {?} */
                    var item = items[i];
                    /** @type {?} */
                    var entry = null;
                    if (this_1.canGetAsEntry(item)) {
                        entry = item.webkitGetAsEntry();
                    }
                    if (!entry) {
                        if (item) {
                            /** @type {?} */
                            var fakeFileEntry = {
                                name: (( /** @type {?} */(item))).name,
                                isDirectory: false,
                                isFile: true,
                                file: function (callback) {
                                    callback(( /** @type {?} */(item)));
                                },
                            };
                            /** @type {?} */
                            var toUpload = new UploadFile(fakeFileEntry.name, fakeFileEntry);
                            this_1.addToQueue(toUpload);
                        }
                    }
                    else {
                        if (entry.isFile) {
                            /** @type {?} */
                            var toUpload = new UploadFile(entry.name, entry);
                            this_1.addToQueue(toUpload);
                        }
                        else if (entry.isDirectory) {
                            this_1.traverseFileTree(entry, entry.name);
                        }
                    }
                };
                var this_1 = this;
                for (var i = 0; i < items.length; i++) {
                    _loop_1(i);
                }
                if (this.dropEventTimerSubscription) {
                    this.dropEventTimerSubscription.unsubscribe();
                }
                this.dropEventTimerSubscription = rxjs.timer(200, 200)
                    .subscribe(function () {
                    if (_this.files.length > 0 && _this.numOfActiveReadEntries === 0) {
                        _this.onFileDrop.emit(new UploadEvent(_this.files));
                        _this.files = [];
                    }
                });
            };
        /**
         * @param {?} item
         * @param {?} path
         * @return {?}
         */
        FileComponent.prototype.traverseFileTree = /**
         * @param {?} item
         * @param {?} path
         * @return {?}
         */
            function (item, path) {
                var _this = this;
                if (item.isFile) {
                    /** @type {?} */
                    var toUpload = new UploadFile(path, item);
                    this.files.push(toUpload);
                }
                else {
                    path = path + '/';
                    /** @type {?} */
                    var dirReader_1 = (( /** @type {?} */(item))).createReader();
                    /** @type {?} */
                    var entries_1 = [];
                    /** @type {?} */
                    var readEntries_1 = function () {
                        _this.numOfActiveReadEntries++;
                        dirReader_1.readEntries(function (result) {
                            if (!result.length) {
                                // add empty folders
                                if (entries_1.length === 0) {
                                    /** @type {?} */
                                    var toUpload_1 = new UploadFile(path, item);
                                    _this.zone.run(function () {
                                        _this.addToQueue(toUpload_1);
                                    });
                                }
                                else {
                                    var _loop_2 = function (i) {
                                        _this.zone.run(function () {
                                            _this.traverseFileTree(entries_1[i], path + entries_1[i].name);
                                        });
                                    };
                                    for (var i = 0; i < entries_1.length; i++) {
                                        _loop_2(i);
                                    }
                                }
                            }
                            else {
                                // continue with the reading
                                entries_1 = entries_1.concat(result);
                                readEntries_1();
                            }
                            _this.numOfActiveReadEntries--;
                        });
                    };
                    readEntries_1();
                }
            };
        /**
         * Clears any added files from the file input element so the same file can subsequently be added multiple times.
         */
        /**
         * Clears any added files from the file input element so the same file can subsequently be added multiple times.
         * @return {?}
         */
        FileComponent.prototype.resetFileInput = /**
         * Clears any added files from the file input element so the same file can subsequently be added multiple times.
         * @return {?}
         */
            function () {
                if (this.fileSelector && this.fileSelector.nativeElement) {
                    /** @type {?} */
                    var fileInputEl = ( /** @type {?} */(this.fileSelector.nativeElement));
                    /** @type {?} */
                    var fileInputContainerEl = fileInputEl.parentElement;
                    /** @type {?} */
                    var helperFormEl = this.getHelperFormElement();
                    /** @type {?} */
                    var fileInputPlaceholderEl = this.getFileInputPlaceholderElement();
                    // Just a quick check so we do not mess up the DOM (will never happen though).
                    if (fileInputContainerEl !== helperFormEl) {
                        // Insert the form input placeholder in the DOM before the form input element.
                        this.renderer.insertBefore(fileInputContainerEl, fileInputPlaceholderEl, fileInputEl);
                        // Add the form input as child of the temporary form element, removing the form input from the DOM.
                        this.renderer.appendChild(helperFormEl, fileInputEl);
                        // Reset the form, thus clearing the input element of any files.
                        helperFormEl.reset();
                        // Add the file input back to the DOM in place of the file input placeholder element.
                        this.renderer.insertBefore(fileInputContainerEl, fileInputEl, fileInputPlaceholderEl);
                        // Remove the input placeholder from the DOM
                        this.renderer.removeChild(fileInputContainerEl, fileInputPlaceholderEl);
                    }
                }
            };
        /**
         * Get a cached HTML form element as a helper element to clear the file input element.
         */
        /**
         * Get a cached HTML form element as a helper element to clear the file input element.
         * @return {?}
         */
        FileComponent.prototype.getHelperFormElement = /**
         * Get a cached HTML form element as a helper element to clear the file input element.
         * @return {?}
         */
            function () {
                if (!this.helperFormEl) {
                    this.helperFormEl = ( /** @type {?} */(this.renderer.createElement('form')));
                }
                return this.helperFormEl;
            };
        /**
         * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
         */
        /**
         * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
         * @return {?}
         */
        FileComponent.prototype.getFileInputPlaceholderElement = /**
         * Get a cached HTML div element to be used as placeholder for the file input element when clearing said element.
         * @return {?}
         */
            function () {
                if (!this.fileInputPlaceholderEl) {
                    this.fileInputPlaceholderEl = ( /** @type {?} */(this.renderer.createElement('div')));
                }
                return this.fileInputPlaceholderEl;
            };
        /**
         * @param {?} item
         * @return {?}
         */
        FileComponent.prototype.canGetAsEntry = /**
         * @param {?} item
         * @return {?}
         */
            function (item) {
                return !!item.webkitGetAsEntry;
            };
        /**
         * @return {?}
         */
        FileComponent.prototype.isDropzoneDisabled = /**
         * @return {?}
         */
            function () {
                return (this.globalDraggingInProgress || this.disabled);
            };
        /**
         * @param {?} item
         * @return {?}
         */
        FileComponent.prototype.addToQueue = /**
         * @param {?} item
         * @return {?}
         */
            function (item) {
                this.files.push(item);
            };
        /**
         * @param {?} event
         * @return {?}
         */
        FileComponent.prototype.preventAndStop = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                event.stopPropagation();
                event.preventDefault();
            };
        FileComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'file-drop',
                        template: "<div [className]=\"dropZoneClassName\"\r\n     [class.over]=\"isDraggingOverDropZone\"\r\n     [class.ngx-file-drop__drop-zone--over]=\"isDraggingOverDropZone\"\r\n     (drop)=\"dropFiles($event)\"\r\n     (dragover)=\"onDragOver($event)\"\r\n     (dragleave)=\"onDragLeave($event)\">\r\n    <div [className]=\"contentClassName\">\r\n        <ng-content></ng-content>\r\n        <div *ngIf=\"dropZoneLabel\" class=\"ngx-file-drop__drop-zone-label\">{{dropZoneLabel}}</div>\r\n        <div *ngIf=\"showBrowseBtn\">\r\n            <input type=\"file\" #fileSelector [accept]=\"accept\" (change)=\"uploadFiles($event)\" multiple class=\"ngx-file-drop__file-input\" />\r\n            <input type=\"button\" [className]=\"browseBtnClassName\" value=\"{{browseBtnLabel}}\" (click)=\"onBrowseButtonClick($event)\" />\r\n        </div>\r\n    </div>\r\n</div>\r\n",
                        styles: [".drop-zone{height:100px;margin:auto;border:2px dotted #0782d0;border-radius:30px}.over{background-color:rgba(147,147,147,.5)}.content{display:flex;align-items:center;justify-content:center;height:100px;color:#0782d0}.ngx-file-drop__drop-zone-label{text-align:center}.ngx-file-drop__file-input{display:none}"]
                    }] }
        ];
        /** @nocollapse */
        FileComponent.ctorParameters = function () {
            return [
                { type: core.NgZone },
                { type: core.Renderer2 }
            ];
        };
        FileComponent.propDecorators = {
            accept: [{ type: core.Input }],
            dropZoneLabel: [{ type: core.Input }],
            headertext: [{ type: core.Input }],
            dropZoneClassName: [{ type: core.Input }],
            customstyle: [{ type: core.Input }],
            contentClassName: [{ type: core.Input }],
            customContentStyle: [{ type: core.Input }],
            disabled: [{ type: core.Input }],
            disableIf: [{ type: core.Input }],
            showBrowseBtn: [{ type: core.Input }],
            browseBtnClassName: [{ type: core.Input }],
            customBtnStyling: [{ type: core.Input }],
            browseBtnLabel: [{ type: core.Input }],
            onFileDrop: [{ type: core.Output }],
            onFileOver: [{ type: core.Output }],
            onFileLeave: [{ type: core.Output }],
            fileSelector: [{ type: core.ViewChild, args: ['fileSelector',] }]
        };
        return FileComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
     */
    var FileDropModule = /** @class */ (function () {
        function FileDropModule() {
        }
        FileDropModule.decorators = [
            { type: core.NgModule, args: [{
                        declarations: [
                            FileComponent,
                        ],
                        exports: [FileComponent],
                        imports: [common.CommonModule],
                        providers: [],
                        bootstrap: [FileComponent],
                    },] }
        ];
        return FileDropModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
     */

    exports.FileComponent = FileComponent;
    exports.FileDropModule = FileDropModule;
    exports.UploadFile = UploadFile;
    exports.UploadEvent = UploadEvent;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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