import { OnChanges, OnDestroy, EventEmitter, ApplicationRef, ElementRef, ViewContainerRef, Injector, ComponentFactoryResolver } from '@angular/core';
import { ColorPickerService } from './color-picker.service';
import { AlphaChannel, ColorMode, OutputFormat } from './helpers';
export declare class ColorPickerDirective implements OnChanges, OnDestroy {
    private injector;
    private cfr;
    private appRef;
    private vcRef;
    private elRef;
    private _service;
    private dialog;
    private dialogCreated;
    private ignoreChanges;
    private cmpRef;
    colorPicker: string;
    cpWidth: string;
    cpHeight: string;
    cpToggle: boolean;
    cpDisabled: boolean;
    cpIgnoredElements: any;
    cpFallbackColor: string;
    cpColorMode: ColorMode;
    cpOutputFormat: OutputFormat;
    cpAlphaChannel: AlphaChannel;
    cpDisableInput: boolean;
    cpDialogDisplay: string;
    cpSaveClickOutside: boolean;
    cpCloseClickOutside: boolean;
    cpUseRootViewContainer: boolean;
    cpPosition: string;
    cpPositionOffset: string;
    cpPositionRelativeToArrow: boolean;
    cpOKButton: boolean;
    cpOKButtonText: string;
    cpOKButtonClass: string;
    cpCancelButton: boolean;
    cpCancelButtonText: string;
    cpCancelButtonClass: string;
    cpPresetLabel: string;
    cpPresetColors: string[];
    cpMaxPresetColorsLength: number;
    cpPresetEmptyMessage: string;
    cpPresetEmptyMessageClass: string;
    cpAddColorButton: boolean;
    cpAddColorButtonText: string;
    cpAddColorButtonClass: string;
    cpRemoveColorButtonClass: string;
    cpInputChange: EventEmitter<any>;
    cpToggleChange: EventEmitter<boolean>;
    cpSliderChange: EventEmitter<any>;
    cpSliderDragEnd: EventEmitter<string>;
    cpSliderDragStart: EventEmitter<string>;
    colorPickerOpen: EventEmitter<string>;
    colorPickerClose: EventEmitter<string>;
    colorPickerCancel: EventEmitter<string>;
    colorPickerSelect: EventEmitter<string>;
    colorPickerChange: EventEmitter<string>;
    cpPresetColorsChange: EventEmitter<any>;
    handleClick(): void;
    handleFocus(): void;
    handleInput(event: any): void;
    constructor(injector: Injector, cfr: ComponentFactoryResolver, appRef: ApplicationRef, vcRef: ViewContainerRef, elRef: ElementRef, _service: ColorPickerService);
    ngOnDestroy(): void;
    ngOnChanges(changes: any): void;
    openDialog(): void;
    closeDialog(): void;
    stateChanged(state: boolean): void;
    colorChanged(value: string, ignore?: boolean): void;
    colorCanceled(): void;
    colorSelected(value: string): void;
    inputFocus(): void;
    inputChange(event: any): void;
    inputChanged(event: any): void;
    sliderChanged(event: any): void;
    sliderDragEnd(event: any): void;
    sliderDragStart(event: any): void;
    presetColorsChanged(value: any[]): void;
}
