/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { getOppositePlacement } from './getOppositePlacement';
import { getOuterSizes } from './getOuterSizes';
/**
 * @param {?} target
 * @param {?} hostOffsets
 * @param {?} position
 * @return {?}
 */
export function getTargetOffsets(target, hostOffsets, position) {
    var /** @type {?} */ placement = position.split(' ')[0];
    // Get target node sizes
    var /** @type {?} */ targetRect = getOuterSizes(target);
    // Add position, width and height to our offsets object
    var /** @type {?} */ targetOffsets = {
        width: targetRect.width,
        height: targetRect.height
    };
    // depending by the target placement we have to compute its offsets slightly differently
    var /** @type {?} */ isHoriz = ['right', 'left'].indexOf(placement) !== -1;
    var /** @type {?} */ mainSide = isHoriz ? 'top' : 'left';
    var /** @type {?} */ secondarySide = isHoriz ? 'left' : 'top';
    var /** @type {?} */ measurement = isHoriz ? 'height' : 'width';
    var /** @type {?} */ secondaryMeasurement = !isHoriz ? 'height' : 'width';
    targetOffsets[mainSide] =
        hostOffsets[mainSide] +
            hostOffsets[measurement] / 2 -
            targetRect[measurement] / 2;
    targetOffsets[secondarySide] = placement === secondarySide
        ? hostOffsets[secondarySide] - targetRect[secondaryMeasurement]
        : hostOffsets[getOppositePlacement(secondarySide)];
    return targetOffsets;
}

//# sourceMappingURL=data:application/json;base64,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