/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { computeAutoPlacement, getReferenceOffsets, getTargetOffsets } from '../utils';
/**
 * @param {?} targetElement
 * @param {?} hostElement
 * @param {?} position
 * @return {?}
 */
export function initData(targetElement, hostElement, position) {
    var /** @type {?} */ hostElPosition = getReferenceOffsets(targetElement, hostElement);
    var /** @type {?} */ targetOffset = getTargetOffsets(targetElement, hostElPosition, position);
    var /** @type {?} */ placement = computeAutoPlacement(position, hostElPosition, targetElement, hostElement, 'viewport', 0);
    var /** @type {?} */ placementAuto = position.indexOf('auto') !== -1;
    return {
        instance: {
            target: targetElement,
            host: hostElement,
            arrow: null
        },
        offsets: {
            target: targetOffset,
            host: hostElPosition,
            arrow: null
        },
        positionFixed: false,
        placement: placement,
        placementAuto: placementAuto
    };
}

//# sourceMappingURL=data:application/json;base64,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